/*
 * Decompiled with CFR 0.152.
 */
package weaver.agent.net.sf.ezmorph;

import java.math.BigDecimal;
import java.math.BigInteger;
import weaver.agent.net.sf.ezmorph.MorpherRegistry;
import weaver.agent.net.sf.ezmorph.array.BooleanArrayMorpher;
import weaver.agent.net.sf.ezmorph.array.ByteArrayMorpher;
import weaver.agent.net.sf.ezmorph.array.CharArrayMorpher;
import weaver.agent.net.sf.ezmorph.array.DoubleArrayMorpher;
import weaver.agent.net.sf.ezmorph.array.FloatArrayMorpher;
import weaver.agent.net.sf.ezmorph.array.IntArrayMorpher;
import weaver.agent.net.sf.ezmorph.array.LongArrayMorpher;
import weaver.agent.net.sf.ezmorph.array.ObjectArrayMorpher;
import weaver.agent.net.sf.ezmorph.array.ShortArrayMorpher;
import weaver.agent.net.sf.ezmorph.object.BooleanObjectMorpher;
import weaver.agent.net.sf.ezmorph.object.CharacterObjectMorpher;
import weaver.agent.net.sf.ezmorph.object.ClassMorpher;
import weaver.agent.net.sf.ezmorph.object.NumberMorpher;
import weaver.agent.net.sf.ezmorph.object.StringMorpher;
import weaver.agent.net.sf.ezmorph.primitive.BooleanMorpher;
import weaver.agent.net.sf.ezmorph.primitive.ByteMorpher;
import weaver.agent.net.sf.ezmorph.primitive.CharMorpher;
import weaver.agent.net.sf.ezmorph.primitive.DoubleMorpher;
import weaver.agent.net.sf.ezmorph.primitive.FloatMorpher;
import weaver.agent.net.sf.ezmorph.primitive.IntMorpher;
import weaver.agent.net.sf.ezmorph.primitive.LongMorpher;
import weaver.agent.net.sf.ezmorph.primitive.ShortMorpher;

public class MorphUtils {
    public static final BigDecimal BIGDECIMAL_ONE = new BigDecimal("1");
    public static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal("0");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public static void registerStandardMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.clear();
        MorphUtils.registerStandardPrimitiveMorphers(morpherRegistry);
        MorphUtils.registerStandardPrimitiveArrayMorphers(morpherRegistry);
        MorphUtils.registerStandardObjectMorphers(morpherRegistry);
        MorphUtils.registerStandardObjectArrayMorphers(morpherRegistry);
    }

    public static void registerStandardObjectArrayMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new BooleanObjectMorpher(Boolean.FALSE)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new CharacterObjectMorpher(new Character('\u0000'))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(StringMorpher.getInstance()));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(clazz, new Byte(0))));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(clazz2, new Short(0))));
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(clazz3, new Integer(0))));
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(clazz4, new Long(0L))));
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(clazz5, new Float(0.0f))));
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(clazz6, new Double(0.0))));
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(clazz7, BigInteger.ZERO)));
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(clazz8, BIGDECIMAL_ZERO)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(ClassMorpher.getInstance()));
    }

    public static void registerStandardObjectMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanObjectMorpher(Boolean.FALSE));
        morpherRegistry.registerMorpher(new CharacterObjectMorpher(new Character('\u0000')));
        morpherRegistry.registerMorpher(StringMorpher.getInstance());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new NumberMorpher(clazz, new Byte(0)));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new NumberMorpher(clazz2, new Short(0)));
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new NumberMorpher(clazz3, new Integer(0)));
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new NumberMorpher(clazz4, new Long(0L)));
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new NumberMorpher(clazz5, new Float(0.0f)));
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new NumberMorpher(clazz6, new Double(0.0)));
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new NumberMorpher(clazz7, BigInteger.ZERO));
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.registerMorpher(new NumberMorpher(clazz8, BIGDECIMAL_ZERO));
        morpherRegistry.registerMorpher(ClassMorpher.getInstance());
    }

    public static void registerStandardPrimitiveArrayMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanArrayMorpher(false));
        morpherRegistry.registerMorpher(new CharArrayMorpher('\u0000'));
        morpherRegistry.registerMorpher(new ByteArrayMorpher(0));
        morpherRegistry.registerMorpher(new ShortArrayMorpher(0));
        morpherRegistry.registerMorpher(new IntArrayMorpher(0));
        morpherRegistry.registerMorpher(new LongArrayMorpher(0L));
        morpherRegistry.registerMorpher(new FloatArrayMorpher(0.0f));
        morpherRegistry.registerMorpher(new DoubleArrayMorpher(0.0));
    }

    public static void registerStandardPrimitiveMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanMorpher(false));
        morpherRegistry.registerMorpher(new CharMorpher('\u0000'));
        morpherRegistry.registerMorpher(new ByteMorpher(0));
        morpherRegistry.registerMorpher(new ShortMorpher(0));
        morpherRegistry.registerMorpher(new IntMorpher(0));
        morpherRegistry.registerMorpher(new LongMorpher(0L));
        morpherRegistry.registerMorpher(new FloatMorpher(0.0f));
        morpherRegistry.registerMorpher(new DoubleMorpher(0.0));
    }

    private MorphUtils() {
    }
}

