/*
 * Decompiled with CFR 0.152.
 */
package weaver.agent.net.sf.json;

import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weaver.agent.net.sf.json.JSON;
import weaver.agent.net.sf.json.JSONArray;
import weaver.agent.net.sf.json.JSONException;
import weaver.agent.net.sf.json.JSONFunction;
import weaver.agent.net.sf.json.JSONNull;
import weaver.agent.net.sf.json.JSONObject;
import weaver.agent.net.sf.json.JSONSerializer;
import weaver.agent.net.sf.json.JSONString;
import weaver.agent.net.sf.json.JsonConfig;
import weaver.agent.net.sf.json.util.JSONUtils;
import weaver.agent.net.sf.json.util.JsonEventListener;
import weaver.agent.org.apache.commons.logging.Log;
import weaver.agent.org.apache.commons.logging.LogFactory;

abstract class AbstractJSON {
    private static CycleSet cycleSet = new CycleSet();
    private static final Log log = LogFactory.getLog(class$net$sf$json$AbstractJSON == null ? (class$net$sf$json$AbstractJSON = AbstractJSON.class$("weaver.agent.net.sf.json.AbstractJSON")) : class$net$sf$json$AbstractJSON);
    static /* synthetic */ Class class$net$sf$json$AbstractJSON;
    static /* synthetic */ Class class$java$lang$Class;

    AbstractJSON() {
    }

    protected static boolean addInstance(Object instance) {
        return AbstractJSON.getCycleSet().add(instance);
    }

    protected static void fireArrayEndEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onArrayEnd();
                }
                catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        }
    }

    protected static void fireArrayStartEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onArrayStart();
                }
                catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        }
    }

    protected static void fireElementAddedEvent(int index, Object element, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onElementAdded(index, element);
                }
                catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        }
    }

    protected static void fireErrorEvent(JSONException jsone, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onError(jsone);
                }
                catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        }
    }

    protected static void fireObjectEndEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onObjectEnd();
                }
                catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        }
    }

    protected static void fireObjectStartEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onObjectStart();
                }
                catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        }
    }

    protected static void firePropertySetEvent(String key, Object value, boolean accumulated, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onPropertySet(key, value, accumulated);
                }
                catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        }
    }

    protected static void fireWarnEvent(String warning, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onWarning(warning);
                }
                catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        }
    }

    protected static void removeInstance(Object instance) {
        Set set = AbstractJSON.getCycleSet();
        set.remove(instance);
        if (set.size() == 0) {
            cycleSet.remove();
        }
    }

    protected Object _processValue(Object value, JsonConfig jsonConfig) {
        if (JSONNull.getInstance().equals(value)) {
            return JSONNull.getInstance();
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = AbstractJSON.class$("java.lang.Class")) : class$java$lang$Class).isAssignableFrom(value.getClass()) || value instanceof Class) {
            return ((Class)value).getName();
        }
        if (JSONUtils.isFunction(value)) {
            if (value instanceof String) {
                value = JSONFunction.parse((String)value);
            }
            return value;
        }
        if (value instanceof JSONString) {
            return JSONSerializer.toJSON((Object)((JSONString)value), jsonConfig);
        }
        if (value instanceof JSON) {
            return JSONSerializer.toJSON(value, jsonConfig);
        }
        if (JSONUtils.isArray(value)) {
            return JSONArray.fromObject(value, jsonConfig);
        }
        if (JSONUtils.isString(value)) {
            String str = String.valueOf(value);
            if (JSONUtils.hasQuotes(str)) {
                String stripped = JSONUtils.stripQuotes(str);
                if (JSONUtils.isFunction(stripped)) {
                    return "\"" + stripped + "\"";
                }
                if (stripped.startsWith("[") && stripped.endsWith("]")) {
                    return stripped;
                }
                if (stripped.startsWith("{") && stripped.endsWith("}")) {
                    return stripped;
                }
                return str;
            }
            if (JSONUtils.isJsonKeyword(str, jsonConfig)) {
                if (jsonConfig.isJavascriptCompliant() && "undefined".equals(str)) {
                    return JSONNull.getInstance();
                }
                return str;
            }
            if (JSONUtils.mayBeJSON(str)) {
                try {
                    return JSONSerializer.toJSON((Object)str, jsonConfig);
                }
                catch (JSONException jsone) {
                    return str;
                }
            }
            return str;
        }
        if (JSONUtils.isNumber(value)) {
            JSONUtils.testValidity(value);
            return JSONUtils.transformNumber((Number)value);
        }
        if (JSONUtils.isBoolean(value)) {
            return value;
        }
        JSONObject jsonObject = JSONObject.fromObject(value, jsonConfig);
        if (jsonObject.isNullObject()) {
            return JSONNull.getInstance();
        }
        return jsonObject;
    }

    private static Set getCycleSet() {
        return cycleSet.getSet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CycleSet
    extends ThreadLocal {
        private CycleSet() {
        }

        protected Object initialValue() {
            return new SoftReference(new HashSet());
        }

        public Set getSet() {
            HashSet set = (HashSet)((SoftReference)this.get()).get();
            if (set == null) {
                set = new HashSet();
                this.set(new SoftReference(set));
            }
            return set;
        }
    }
}

