/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect;

import java.io.File;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weaver.agent.javassist.CtClass;
import weaver.security.protect.agent.BaseAgent;
import weaver.security.protect.cache.RuleConfigCache;
import weaver.security.protect.entity.ClassEntity;
import weaver.security.protect.utils.BeanConverter;
import weaver.security.protect.utils.ClassUtils;
import weaver.security.protect.utils.ConfigUtil;
import weaver.security.protect.utils.FileUtil;
import weaver.security.protect.utils.JavassistUtil;
import weaver.security.protect.utils.LogWriter;
import weaver.security.protect.wrapper.ResponseWrapper;

public class RunAgentMain {
    private Map<String, Class> agentTemplateMap = new HashMap<String, Class>();
    public static Instrumentation weaverInstrumentation;
    public static boolean isLog;
    public static Set<String> classCache;

    public RunAgentMain() {
    }

    public RunAgentMain(String params, Instrumentation instrumentation, boolean isLog) {
        RunAgentMain.isLog = isLog;
        weaverInstrumentation = instrumentation;
        ConfigUtil.analysisParam(params);
        try {
            this.agentTemplateMap = ClassUtils.agentTemplateMap(BaseAgent.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u83b7\u53d6\u6267\u884c\u63d2\u6869\u89c4\u5219\u7684\u6a21\u677f\u5b9e\u4f8b\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\uff1a" + e.toString());
        }
    }

    public void entrance() throws Exception {
        this.saveOldClassToFile();
        FileUtil.clearEnhanceFile();
        this.doEntrance();
    }

    public void doEntrance() throws Exception {
        Class[] loadedClasses;
        LogWriter.writeLog("need enhance target\uff1a" + BeanConverter.listToJson(RuleConfigCache.getAnalysisParam()));
        HashMap<String, CtClass> tmpMap = new HashMap<String, CtClass>();
        List<BaseAgent> baseAgents = this.agentTemplateList();
        for (Class loadedClass : loadedClasses = weaverInstrumentation.getAllLoadedClasses()) {
            String name = loadedClass.getName();
            for (BaseAgent driverAgent : baseAgents) {
                if (!driverAgent.isSupport(name)) continue;
                ResponseWrapper responseWrapper = driverAgent.enhanceClass(loadedClass);
                CtClass ctClass = responseWrapper.getCtClass();
                weaverInstrumentation.redefineClasses(new ClassDefinition(loadedClass, ctClass.toBytecode()));
                ctClass.detach();
                FileUtil.writeClassFile(ctClass);
                tmpMap.put(name, ctClass);
                classCache.add(name);
                LogWriter.printEnhanceLog(responseWrapper.getClassEntity());
            }
        }
        LogWriter.writeLog("enhance success, class sum = " + tmpMap.size());
    }

    public void doEntranceThread() throws Exception {
        Class[] loadedClasses;
        List<BaseAgent> baseAgents = this.agentTemplateList();
        for (Class loadedClass : loadedClasses = weaverInstrumentation.getAllLoadedClasses()) {
            String name = loadedClass.getName();
            for (BaseAgent driverAgent : baseAgents) {
                if (!driverAgent.isSupport(name)) continue;
                ResponseWrapper responseWrapper = driverAgent.enhanceClass(loadedClass);
                CtClass ctClass = responseWrapper.getCtClass();
                weaverInstrumentation.redefineClasses(new ClassDefinition(loadedClass, ctClass.toBytecode()));
                ctClass.detach();
            }
        }
    }

    public void saveOldClassToFile() throws Exception {
        Class[] loadedClasses = weaverInstrumentation.getAllLoadedClasses();
        List<ClassEntity> classEntities = ConfigUtil.classEntityTargetList();
        String path = RuleConfigCache.getOriginWritePathCache();
        block0: for (Class loadedClass : loadedClasses) {
            String name = loadedClass.getName();
            for (ClassEntity classEntity : classEntities) {
                if (!classEntity.getTargetClassName().equals(name)) continue;
                byte[] bytes = JavassistUtil.writeOldClassFileToByte(loadedClass);
                String namePackage = loadedClass.getName().replace(".", "/").concat(".class.origin");
                if (!FileUtil.writeClassFile(path + "/" + namePackage, bytes)) continue block0;
                LogWriter.writeLog("write to disk success\uff0cposition\uff1a" + path + "/" + namePackage);
                continue block0;
            }
        }
    }

    public boolean newRecoveryOldClass(String className) throws Exception {
        if (className != null && !"".equals(className)) {
            return this.newRecoverySingleOriginClass(className);
        }
        return this.newRecoveryAllOldClass();
    }

    public boolean newRecoveryAllOldClass() {
        HashSet<Boolean> resultFlag = new HashSet<Boolean>();
        List<ClassEntity> classEntities = ConfigUtil.classEntityTargetList();
        for (ClassEntity classEntity : classEntities) {
            String targetClassName = classEntity.getTargetClassName();
            boolean b = this.newRecoverySingleOriginClass(targetClassName);
            resultFlag.add(b);
            LogWriter.writeLog("\u6587\u4ef6\uff1a" + targetClassName + "\uff0c\u662f\u5426\u6062\u590d\u6210\u529f\uff1a" + b);
        }
        return !resultFlag.contains(false);
    }

    public boolean newRecoverySingleOriginClass(String className) {
        try {
            Class[] allLoadedClasses;
            String path = RuleConfigCache.getOriginWritePathCache();
            String namePackage = path + "/" + className.replace(".", "/").concat(".class.origin");
            if (!FileUtil.isFileExists(new File(namePackage))) {
                LogWriter.writeLog("\u6062\u590d\u7684\u6587\u4ef6\u672a\u5728\u6307\u5b9a\u4f4d\u7f6e\u4e2d\u627e\u5230\uff0c\u8def\u5f84\uff1a" + namePackage);
                return false;
            }
            byte[] bytes = FileUtil.readToByte(namePackage);
            for (Class aClass : allLoadedClasses = weaverInstrumentation.getAllLoadedClasses()) {
                String name = aClass.getName();
                if (!name.equals(className)) continue;
                weaverInstrumentation.redefineClasses(new ClassDefinition(aClass, bytes));
                LogWriter.writeLog(className + "\u6062\u590d\u6210\u529f");
            }
        }
        catch (Exception e) {
            LogWriter.writeError("\u6062\u590d\u539f\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage() + "\uff0c\u6587\u4ef6\uff1a" + className, e);
            return false;
        }
        return true;
    }

    private List<BaseAgent> agentTemplateList() throws Exception {
        ArrayList<BaseAgent> baseAgents = new ArrayList<BaseAgent>();
        List<ClassEntity> classEntities = ConfigUtil.classEntityTargetList();
        for (ClassEntity classEntity : classEntities) {
            baseAgents.add(this.generateBaseAgent(classEntity));
        }
        return baseAgents;
    }

    private BaseAgent generateBaseAgent(ClassEntity classEntity) {
        String checkFlag = classEntity.getCheckRule();
        if (checkFlag == null || "".equals(checkFlag)) {
            throw new RuntimeException("\u63d2\u6869\u6807\u8bc6\u4e3a\u7a7a");
        }
        Class aClass = this.agentTemplateMap.get(checkFlag);
        if (aClass == null) {
            throw new RuntimeException("\u83b7\u53d6\u6a21\u677f\u5bf9\u8c61\u4e3a\u7a7a\uff1acheckRule = " + checkFlag + ",classEntity = " + classEntity + ",agentTemplateMap = " + this.agentTemplateMap);
        }
        try {
            Object o = aClass.newInstance();
            Method setClassEntity = aClass.getMethod("setClassEntity", ClassEntity.class);
            setClassEntity.invoke(o, classEntity);
            return (BaseAgent)o;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f8b\u5316\u63d2\u6869\u5bf9\u8c61\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public Map<String, Map<String, Class>> checkMemoryHorse() throws Exception {
        HashMap<String, Map<String, Class>> resultMap = new HashMap<String, Map<String, Class>>();
        HashMap<String, Class> normal = new HashMap<String, Class>();
        HashMap<String, Class> notNormal = new HashMap<String, Class>();
        String realPath = "";
        String rootPath = (String)RuleConfigCache.getCache("rootPath");
        LogWriter.writeLog("check memory horse root path = " + rootPath);
        LogWriter.writeLog("weaverInstrumentation = " + weaverInstrumentation);
        Map<String, Class> classMap = this.getClassToInterfacesAndSuperclass();
        if (classMap.isEmpty()) {
            return resultMap;
        }
        Set<Map.Entry<String, Class>> entries = classMap.entrySet();
        for (Map.Entry<String, Class> entry : entries) {
            String className = entry.getKey();
            Class clazz = entry.getValue();
            try {
                CodeSource codeSource;
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                    URL location = codeSource.getLocation();
                    try {
                        realPath = URLDecoder.decode(location.getPath(), "utf-8");
                    }
                    catch (Throwable e) {
                        realPath = "";
                    }
                }
                if (realPath.endsWith(".jar") || className.endsWith("_jsp") && className.startsWith("_jsp.")) continue;
                String classNamePath = className.replace(".", "/").concat(".class");
                String classBeanPath = rootPath + "classbean/";
                String classesPath = rootPath + "WEB-INF/classes/";
                String myClassesPath = rootPath + "WEB-INF/myclasses/";
                ArrayList<String> pathList = new ArrayList<String>();
                pathList.add(classBeanPath);
                pathList.add(myClassesPath);
                pathList.add(classesPath);
                boolean flag = false;
                for (String path : pathList) {
                    if (!FileUtil.isFileExists(path + classNamePath)) continue;
                    normal.put(className, clazz);
                    flag = true;
                    break;
                }
                if (flag) continue;
                LogWriter.writeLog("className = " + className + " \u4e0d\u5b58\u5728\uff0c\u8def\u5f84 = " + realPath);
                notNormal.put(className, clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogWriter.writeError("check target class file exception = ", e);
            }
        }
        resultMap.put("normal", normal);
        resultMap.put("notNormal", notNormal);
        return resultMap;
    }

    public String getInterfaces(Class allLoadedClass, Set<String> set) {
        Class<?>[] interfaces = allLoadedClass.getInterfaces();
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> anInterface : interfaces) {
            stringBuilder.append(anInterface.getName() + ",");
            set.add(anInterface.getName());
        }
        return stringBuilder.toString();
    }

    public String getSuperclass(Class allLoadedClass, Set<String> set) {
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Class superclass = allLoadedClass.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
            Class<?>[] interfaces1;
            String superclassName = superclass.getName();
            set.add(superclassName);
            stringBuilder2.append(superclassName).append(",");
            for (Class<?> anInterface : interfaces1 = superclass.getInterfaces()) {
                set.add(anInterface.getName());
                stringBuilder2.append(anInterface.getName()).append(",");
            }
        }
        return stringBuilder2.toString();
    }

    public Map<String, Class> getClassToInterfacesAndSuperclass() {
        Class[] loadedClasses;
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        for (Class aClass : loadedClasses = weaverInstrumentation.getAllLoadedClasses()) {
            try {
                HashSet<String> classSet = new HashSet<String>();
                String interfaces = this.getInterfaces(aClass, classSet);
                String superclass = this.getSuperclass(aClass, classSet);
                if (!classSet.contains("javax.servlet.Servlet") && !classSet.contains("javax.servlet.Filter")) continue;
                LogWriter.writeLog("className = " + aClass.getName() + " [interfaces = " + interfaces + " superclass = " + superclass + "]");
                classMap.put(aClass.getName(), aClass);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogWriter.writeError("find target class file exception = ", e);
            }
        }
        return classMap;
    }

    static {
        isLog = true;
        classCache = new HashSet<String>();
    }
}

