/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect.agent;

import weaver.agent.javassist.ClassPool;
import weaver.agent.javassist.CtClass;
import weaver.agent.javassist.LoaderClassPath;
import weaver.security.protect.agent.BaseAgent;
import weaver.security.protect.entity.ClassEntity;
import weaver.security.protect.utils.JavassistUtil;
import weaver.security.protect.wrapper.ResponseWrapper;

public abstract class ABaseAgent
implements BaseAgent {
    public static final ClassPool classPool = JavassistUtil.classPool;
    private ClassEntity classEntity;

    public ABaseAgent() {
    }

    public ABaseAgent(ClassEntity classEntity) {
        this.classEntity = classEntity;
    }

    @Override
    public boolean isSupport(String className) {
        if (className == null || className.length() <= 0) {
            return false;
        }
        return className.equals(this.classEntity.getTargetClassName());
    }

    @Override
    public CtClass getCtclass(Class loadedClass) throws Exception {
        CtClass ctClass = classPool.get(loadedClass.getName());
        if (ctClass.isFrozen()) {
            ctClass.defrost();
        }
        return ctClass;
    }

    @Override
    public ResponseWrapper enhanceClass(Class loadedClass) throws Exception {
        LoaderClassPath loaderClassPath = new LoaderClassPath(loadedClass.getClassLoader());
        classPool.appendClassPath(loaderClassPath);
        CtClass ctclass = this.getCtclass(loadedClass);
        ResponseWrapper responseWrapper = this.doEnhanceClass(ctclass);
        classPool.removeClassPath(loaderClassPath);
        return responseWrapper;
    }

    public abstract ResponseWrapper doEnhanceClass(CtClass var1) throws Exception;

    public static ClassPool getClassPool() {
        return classPool;
    }

    public ClassEntity getClassEntity() {
        return this.classEntity;
    }

    public void setClassEntity(ClassEntity classEntity) {
        this.classEntity = classEntity;
    }
}

