/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect.utils;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import weaver.security.protect.cache.RuleConfigCache;
import weaver.security.protect.utils.BeanConverter;
import weaver.security.protect.utils.LogWriter;

public class ClassUtils {
    public static Map<String, Class> agentTemplateMap(Class<?> cls) throws Exception {
        System.out.println("=====================begin==================");
        HashMap<String, Class> map = new HashMap<String, Class>();
        List<Class> jarName = ClassUtils.getInterfaceAllChildren(cls);
        for (Class aClass : jarName) {
            Method getCheckRule = aClass.getMethod("getCheckRule", new Class[0]);
            Object rule = getCheckRule.invoke(aClass.newInstance(), new Object[0]);
            if (rule == null) {
                throw new RuntimeException("\u6a21\u677f\u5b9e\u4f8b\u5bf9\u8c61\u68c0\u6d4b\u6807\u8bc6\u4e3a\u7a7a");
            }
            map.put(String.valueOf(rule), aClass);
        }
        LogWriter.writeLog("agent all template\uff1a" + BeanConverter.mapToJson(map));
        return map;
    }

    public static List<Class> getInterfaceAllChildren(Class<?> cls) throws Exception {
        ArrayList<Class> returnClassList = new ArrayList<Class>();
        List<Class> allClass = ClassUtils.getJarAllClass(cls);
        for (Class aClass : allClass) {
            if (!cls.isAssignableFrom(aClass) || cls.getName().equals(aClass.getName()) || Modifier.isAbstract(aClass.getModifiers())) continue;
            returnClassList.add(aClass);
        }
        return returnClassList;
    }

    public static List<Class> getAbstractAllChildren(Class<?> cls) throws Exception {
        ArrayList<Class> returnClassList = new ArrayList<Class>();
        List<Class> allClass = ClassUtils.getJarAllClass(cls);
        for (Class aClass : allClass) {
            if (!cls.isAssignableFrom(aClass) || cls.equals(aClass) || Modifier.isAbstract(aClass.getModifiers())) continue;
            returnClassList.add(aClass);
        }
        return returnClassList;
    }

    public static List<Class> getJarAllClass(Class<?> cls) throws Exception {
        System.out.println("getJarAllClass = " + cls.getName());
        ArrayList<Class> allClass = new ArrayList<Class>();
        try {
            String jarFile = ClassUtils.getClassLocation(cls);
            JarFile jar = new JarFile(new File(jarFile));
            Enumeration<JarEntry> enumFiles = jar.entries();
            String packageName = cls.getName().substring(0, cls.getName().lastIndexOf(".")).replace(".", "/");
            String classFullName = "";
            while (enumFiles.hasMoreElements()) {
                JarEntry entry = enumFiles.nextElement();
                classFullName = entry.getName();
                if (classFullName.indexOf(".class") <= 0 || classFullName.indexOf(packageName) == -1) continue;
                String className = classFullName.substring(0, classFullName.length() - 6).replace("/", ".");
                allClass.add(Class.forName(className));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u63a5\u53e3" + cls.getName() + "\u5f53\u524d\u76ee\u5f55\u4ee5\u53ca\u5b50\u76ee\u5f55\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return allClass;
    }

    public static String getClassLocation(Class<?> cls) {
        if (cls == null) {
            throw new RuntimeException("\u4f20\u9012\u53d1\u503c\u4e0d\u5141\u8bb8\u4e3anull");
        }
        if (cls.getSimpleName().equals("BaseAgent")) {
            String rootPathCache = RuleConfigCache.getRootPathCache() + "WEB-INF/securityRule/newRule/agent/weaver-security-agent.jar";
            LogWriter.writeLog("\u63a5\u53e3\uff1a" + cls.getName() + " \u6240\u5728\u7684\u76ee\u5f55\uff1a" + rootPathCache);
            return rootPathCache;
        }
        URL result = null;
        try {
            String clsAsResource = cls.getName().replace('.', '/').concat(".class");
            ProtectionDomain pd = cls.getProtectionDomain();
            if (pd != null) {
                CodeSource cs = pd.getCodeSource();
                if (cs != null) {
                    result = cs.getLocation();
                }
                if (result != null && "file".equals(result.getProtocol())) {
                    try {
                        if (result.toExternalForm().endsWith(".jar") || result.toExternalForm().endsWith(".zip")) {
                            result = new URL("jar:".concat(result.toExternalForm()).concat("!/").concat(clsAsResource));
                        } else if (new File(result.getFile()).isDirectory()) {
                            result = new URL(result, clsAsResource);
                        }
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("\u5229\u7528ProtectionDomain\u83b7\u53d6\u63a5\u53e3\uff1a" + cls.getName() + " \u6240\u5728\u7684\u4f4d\u7f6e\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                }
            }
            if (result == null) {
                ClassLoader clsLoader = cls.getClassLoader();
                result = clsLoader != null ? clsLoader.getResource(clsAsResource) : ClassLoader.getSystemResource(clsAsResource);
            }
            String s = result.toString().indexOf("!") != -1 ? result.toString().substring(0, result.toString().indexOf("!")) : result.toString();
            s = s.indexOf("jar:file:") != -1 ? s.replace("jar:file:", "") : s;
            s = s.indexOf("file:") != -1 ? s.replace("file:", "") : s;
            s = (s = s.replace("/", File.separator)).indexOf(":") != -1 ? s.substring(1, s.length()) : (s.startsWith("/") ? "/" + s : s);
            LogWriter.writeLog("\u63a5\u53e3\uff1a" + cls.getName() + " \u6240\u5728\u7684\u4f4d\u7f6e\uff1a" + s);
            return s;
        }
        catch (Exception e) {
            System.out.println("\u51fa\u73b0\u5f02\u5e38\uff1a" + e.toString());
            throw new RuntimeException("\u83b7\u53d6\u63a5\u53e3\uff1a" + cls.getName() + " \u6240\u5728\u7684\u4f4d\u7f6e\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

