/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weaver.security.protect.cache.RuleConfigCache;
import weaver.security.protect.entity.ClassEntity;
import weaver.security.protect.entity.MethodEntity;
import weaver.security.protect.utils.BeanConverter;
import weaver.security.protect.utils.CommonUtil;
import weaver.security.protect.utils.LogWriter;

public class ConfigUtil {
    public static Map<String, String> paramMap = new HashMap<String, String>();

    public static String getParam(String key) {
        return paramMap.get(key) == null ? "" : String.valueOf(paramMap.get(key));
    }

    public static void analysisParam(String args) {
        LogWriter.writeLog("access param\uff1a" + args);
        try {
            paramMap = BeanConverter.JsontoMap(args);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790\u63a5\u6536\u7684\u53c2\u6570\u5f02\u5e38\uff1a" + e.getMessage());
        }
        LogWriter.writeLog("analysis param\uff1a" + BeanConverter.mapToJson(paramMap));
        ConfigUtil.initCache();
        ConfigUtil.classEntityTargetList();
        LogWriter.writeLog("cache data\uff1a" + RuleConfigCache.printCacheInfo());
    }

    public static void initCache() {
        RuleConfigCache.clear();
        ConfigUtil.initPath();
    }

    public static void initPath() {
        String rootPath = CommonUtil.getRootPath();
        String writePath = rootPath + "WEB-INF/securityRule/newRule/entranceClass";
        String originWritePath = rootPath + "WEB-INF/securityRule/newRule/originClass";
        LogWriter.writeLog("root directory: " + rootPath + "\uff0corigin class write directory: " + originWritePath + "\uff0cenhance class write directory: " + writePath);
        RuleConfigCache.putCache("rootPath", rootPath);
        RuleConfigCache.putCache("writePath", writePath);
        RuleConfigCache.putCache("originWritePath", originWritePath);
    }

    public static List<ClassEntity> classEntityTargetList() {
        ArrayList<ClassEntity> returnData = new ArrayList<ClassEntity>();
        HashMap agentEntityMap = new HashMap();
        String agntEntityObj = ConfigUtil.getParam("agntEntity");
        if ("".equals(agntEntityObj)) {
            return new ArrayList<ClassEntity>();
        }
        try {
            List<Map<String, String>> agentEntitys = BeanConverter.JsontoList(agntEntityObj);
            for (Map<String, String> map : agentEntitys) {
                String checkRule = map.get("checkRule");
                List entitys = (List)agentEntityMap.get(checkRule);
                if (entitys == null) {
                    ArrayList<Map<String, String>> agentEntities = new ArrayList<Map<String, String>>();
                    agentEntities.add(map);
                    agentEntityMap.put(checkRule, agentEntities);
                    continue;
                }
                entitys.add(map);
            }
            for (Map.Entry entry : agentEntityMap.entrySet()) {
                HashMap<String, ClassEntity> tmpMap = new HashMap<String, ClassEntity>();
                String checkRule = (String)entry.getKey();
                List agentEntityList = (List)entry.getValue();
                for (Map map : agentEntityList) {
                    MethodEntity methodEntity;
                    String className = (String)map.get("targetClassName");
                    String methodName = (String)map.get("methodName");
                    String params = (String)map.get("params");
                    String paramIndex = (String)map.get("paramIndex");
                    String checkClass = (String)map.get("checkClass");
                    ClassEntity classEntity = (ClassEntity)tmpMap.get(className);
                    if (classEntity == null) {
                        ClassEntity classObj = new ClassEntity(checkRule, className);
                        methodEntity = new MethodEntity(methodName, params, paramIndex, checkClass);
                        ArrayList<MethodEntity> methodEntitys = new ArrayList<MethodEntity>();
                        methodEntitys.add(methodEntity);
                        classObj.setMethods(methodEntitys);
                        tmpMap.put(className, classObj);
                        continue;
                    }
                    List<MethodEntity> methods = classEntity.getMethods();
                    methodEntity = new MethodEntity(methodName, params, paramIndex, checkClass);
                    methods.add(methodEntity);
                }
                returnData.addAll(tmpMap.values());
            }
            RuleConfigCache.putCache("enhanceObj", returnData);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5c01\u88c5\u53c2\u6570\u5f02\u5e38:" + e.getMessage());
        }
        return returnData;
    }
}

