/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context.properties;

import com.alibaba.spring.util.PropertySourcesUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.spring.context.properties.AbstractDubboConfigBinder;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.FieldError;

public class DefaultDubboConfigBinder
extends AbstractDubboConfigBinder {
    @Override
    public <C extends AbstractConfig> void bind(String prefix, C dubboConfig) {
        DataBinder dataBinder = new DataBinder(dubboConfig);
        dataBinder.setIgnoreInvalidFields(this.isIgnoreInvalidFields());
        dataBinder.setIgnoreUnknownFields(this.isIgnoreUnknownFields());
        Map properties = PropertySourcesUtils.getSubProperties(this.getPropertySources(), (String)prefix);
        MutablePropertyValues propertyValues = new MutablePropertyValues(properties);
        dataBinder.bind((PropertyValues)propertyValues);
        BindingResult bindingResult = dataBinder.getBindingResult();
        if (bindingResult.hasGlobalErrors()) {
            throw new RuntimeException("Data bind global error, please check config. config: " + bindingResult.getGlobalError() + "");
        }
        if (bindingResult.hasFieldErrors()) {
            throw new RuntimeException(this.buildErrorMsg(bindingResult.getFieldErrors(), prefix, dubboConfig.getClass().getSimpleName()));
        }
    }

    private String buildErrorMsg(List<FieldError> errors, String prefix, String config) {
        StringBuilder builder = new StringBuilder("Data bind error, please check config. config: " + config + ", prefix: " + prefix + " , error fields: [" + errors.get(0).getField());
        if (errors.size() > 1) {
            IntStream.range(1, errors.size()).forEach(i -> builder.append(", " + ((FieldError)errors.get(i)).getField()));
        }
        builder.append("]");
        return builder.toString();
    }
}

