/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.common.utils.Page;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;

@SPI(value="zookeeper")
public interface ServiceDiscovery
extends Prioritized {
    public void initialize(URL var1) throws Exception;

    public void destroy() throws Exception;

    public void register(ServiceInstance var1) throws RuntimeException;

    public void update(ServiceInstance var1) throws RuntimeException;

    public void unregister(ServiceInstance var1) throws RuntimeException;

    default public int getDefaultPageSize() {
        return 100;
    }

    public Set<String> getServices();

    default public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        LinkedList<ServiceInstance> allInstances = new LinkedList<ServiceInstance>();
        int offset = 0;
        int pageSize = this.getDefaultPageSize();
        Page<ServiceInstance> page = this.getInstances(serviceName, offset, pageSize);
        allInstances.addAll(page.getData());
        while (page.hasNext()) {
            page = this.getInstances(serviceName, offset += page.getDataSize(), pageSize);
            allInstances.addAll(page.getData());
        }
        return Collections.unmodifiableList(allInstances);
    }

    default public Page<ServiceInstance> getInstances(String serviceName, int offset, int pageSize) throws NullPointerException, IllegalArgumentException {
        return this.getInstances(serviceName, offset, pageSize, false);
    }

    default public Page<ServiceInstance> getInstances(String serviceName, int offset, int pageSize, boolean healthyOnly) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Current implementation does not support pagination query method.");
    }

    default public Map<String, Page<ServiceInstance>> getInstances(Iterable<String> serviceNames, int offset, int requestSize) throws NullPointerException, IllegalArgumentException {
        LinkedHashMap<String, Page<ServiceInstance>> instances = new LinkedHashMap<String, Page<ServiceInstance>>();
        for (String serviceName : serviceNames) {
            instances.put(serviceName, this.getInstances(serviceName, offset, requestSize));
        }
        return Collections.unmodifiableMap(instances);
    }

    default public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
    }

    default public void removeServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws IllegalArgumentException {
    }

    default public void dispatchServiceInstancesChangedEvent(String serviceName) {
        this.dispatchServiceInstancesChangedEvent(serviceName, this.getInstances(serviceName));
    }

    default public void dispatchServiceInstancesChangedEvent(String serviceName, String ... otherServiceNames) {
        this.dispatchServiceInstancesChangedEvent(serviceName, this.getInstances(serviceName));
        if (otherServiceNames != null) {
            Stream.of(otherServiceNames).filter(StringUtils::isNotEmpty).forEach(this::dispatchServiceInstancesChangedEvent);
        }
    }

    default public void dispatchServiceInstancesChangedEvent(String serviceName, List<ServiceInstance> serviceInstances) {
        this.dispatchServiceInstancesChangedEvent(new ServiceInstancesChangedEvent(serviceName, serviceInstances));
    }

    default public void dispatchServiceInstancesChangedEvent(ServiceInstancesChangedEvent event) {
        EventDispatcher.getDefaultExtension().dispatch(event);
    }

    default public URL getUrl() {
        return null;
    }

    public ServiceInstance getLocalInstance();

    public String toString();
}

