/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.migration;

import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationStep;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class MigrationRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationRule.class);
    private static final String DUBBO_SERVICEDISCOVERY_MIGRATION_KEY = "dubbo.application.service-discovery.migration";
    public static final String DUBBO_SERVICEDISCOVERY_MIGRATION_GROUP = "MIGRATION";
    public static final String RULE_KEY = ApplicationModel.getName() + ".migration";
    private static DynamicConfiguration configuration = null;
    private String key;
    private MigrationStep step = MigrationStep.FORCE_INTERFACE;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MigrationStep getStep() {
        return this.step;
    }

    public void setStep(MigrationStep step) {
        this.step = step;
    }

    public static MigrationRule parse(String rawRule) {
        if (null == configuration) {
            return MigrationRule.getMigrationRule(null);
        }
        if (StringUtils.isBlank(rawRule) || "INIT".equals(rawRule)) {
            String step = (String)configuration.getInternalProperty(DUBBO_SERVICEDISCOVERY_MIGRATION_KEY);
            return MigrationRule.getMigrationRule(step);
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        MigrationRule migrationRule = null;
        try {
            Map map = (Map)yaml.load(rawRule);
            migrationRule = PojoUtils.mapToPojo(map, MigrationRule.class);
            if (null == migrationRule.getStep()) {
                LOGGER.warn("Failed to parse migrationRule, step is empty, automatically switch to APPLICATION_FIRST.");
                migrationRule = MigrationRule.getMigrationRule(null);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse migrationRule, automatically switch to APPLICATION_FIRST.");
            migrationRule = MigrationRule.getMigrationRule(null);
        }
        return migrationRule;
    }

    public static MigrationRule queryRule() {
        if (null == configuration) {
            return MigrationRule.getMigrationRule(null);
        }
        String rawRule = configuration.getConfig(RULE_KEY, DUBBO_SERVICEDISCOVERY_MIGRATION_GROUP);
        return MigrationRule.parse(rawRule);
    }

    private static MigrationRule getMigrationRule(String step) {
        MigrationRule rule = new MigrationRule();
        rule.setStep(Enum.valueOf(MigrationStep.class, StringUtils.isBlank(step) ? MigrationStep.FORCE_INTERFACE.name() : step));
        return rule;
    }

    static {
        Optional<DynamicConfiguration> optional = ApplicationModel.getEnvironment().getDynamicConfiguration();
        optional.ifPresent(dynamicConfiguration -> {
            configuration = dynamicConfiguration;
        });
    }
}

