/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Collection;
import java.util.stream.Stream;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstancePortCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance) {
        if (serviceInstance.getPort() != null) {
            return;
        }
        Collection<ProtocolConfig> protocols = ApplicationModel.getConfigManager().getProtocols();
        if (CollectionUtils.isEmpty(protocols)) {
            throw new IllegalStateException("We should have at least one protocol configured at this point.");
        }
        Stream<ProtocolConfig> protocolStream = protocols.stream();
        ProtocolConfig protocolConfig = protocolStream.filter(protocol -> "rest".equals(protocol.getName())).findFirst().orElseGet(() -> (ProtocolConfig)protocolStream.findFirst().get());
        if (serviceInstance instanceof DefaultServiceInstance) {
            DefaultServiceInstance instance = (DefaultServiceInstance)serviceInstance;
            if (protocolConfig.getPort() != null) {
                instance.setPort(protocolConfig.getPort());
            }
        }
    }
}

