
<%@ page language="java" contentType="text/html; charset=UTF-8" %>
<%@ page
        import="weaver.filter.SecurityCheckList,weaver.general.Util,java.io.*,java.lang.reflect.InvocationTargetException,weaver.hrm.*" %>
<%@ page import="java.lang.reflect.Method" %>
<%@ page import="java.security.MessageDigest" %>
<%@ page import="java.util.*" %>
<%@ page import="java.util.jar.JarEntry" %>
<%@ page import="java.util.jar.JarFile" %>
<%@ page import="com.thoughtworks.xstream.XStream" %>
<%@ page import="weaver.conn.RecordSet" %>
<%@ page import="weaver.general.BaseBean" %>
<%@ page import="weaver.file.Prop" %>
<%@ page import="weaver.general.GCONST" %>
<%@ page import="weaver.security.classLoader.ClassLoaderManager" %>
<jsp:useBean id="rs" class="weaver.conn.RecordSet" scope="page"/>
<jsp:useBean id="xssutil" class="weaver.filter.XssUtil"></jsp:useBean>
<jsp:useBean id="csui" class="weaver.filter.msg.CheckSecurityUpdateInfo"></jsp:useBean>

<%
    User user = (User) session.getAttribute("weaver_user@bean");
    int UID = xssutil.getIntValue(""+xssutil.getRule().get("userID"),1);
    if (user == null || user.getUID()!=UID) {
        out.println("请使用管理员权限查看");
        return;
    }
%>

<html>
<title>一键巡检</title>
<body>
<table width="100%" border="1" cellpadding="0" cellspacing="0">
    <thead>
    <th width="20%" style="text-align:center;">检查项</th>
    <th width="20%" style="text-align:center;">检查结果</th>
    <th width="60%" style="text-align:center;">详情及处置意见</th>
    </thead>
    <tbody>

    <%
        int type = Util.getIntValue(request.getParameter("type"), -1);
        int code = Util.getIntValue(request.getParameter("code"), -1);
        String nextLine = "<br/>";
        String pass = "<span style=\"color:green;text-align:center;\">检查通过</span>";
        String refuse = "<span style=\"color:red;text-align:center;\">检查不通过</span>";
        String check = "<span style=\"color:yellow;text-align:center;\">需要人工检查</span>";
        String checkStatusMsg = "";
        String checkMessage = "";
    %>
    <tr>

        <td style="text-align:center;">安全包版本检测</td>
        <%
            String ecversion = "";
            String cversion = "";
            String cversionTmp = "";
            rs.execute("select companyname,cversion from license");
            if (rs.next()) {
                cversion = rs.getString("cversion");
                cversionTmp = cversion;
                ecversion = "E" + cversion.substring(0, 1);
            }
            csui.getRemoteServerVersion();
            String newOANowVersion = csui.getNewversion();
            String currentVersion = csui.getVersion();

            String newRuleVersion = csui.getRuleNewVersion();
            String currentRuleVersion = csui.getRuleVersion();

            if (newOANowVersion != null && !"".equals(newOANowVersion.trim())) {
                if (csui.getNewversion().compareTo(csui.getVersion()) > 0) {
                    checkStatusMsg = refuse;
                    checkMessage += "当前OA版本为：" + ecversion + "</br> 当前补丁包版本：" + currentVersion + " 最新官网补丁包版本: " + newOANowVersion
                            + "</br>当前安全补丁版本过低请及时升级到最新版本.";
                    if (csui.getRuleNewVersion().compareTo(csui.getRuleVersion()) > 0) {
                        checkMessage += "</br>当前规则库版本: " + currentRuleVersion + " 最新官网规则库版本: " + newRuleVersion + "</br>当前安全库版本过低请及时升级到最新版本.";
                    } else {
                        checkMessage += "</br>当前规则库版本: " + currentRuleVersion + " 最新官网规则库版本: " + newRuleVersion + "</br>当前安全库版本已是最新版本.";
                    }
                } else {
                    checkStatusMsg = pass;
                    checkMessage += "当前OA版本为：" + ecversion + "</br> 当前补丁包版本：" + currentVersion + " 最新官网补丁包版本: " + newOANowVersion
                            + "</br>当前安全补丁版本已是最新.";
                    if (csui.getRuleNewVersion().compareTo(csui.getRuleVersion()) > 0) {
                        checkStatusMsg = refuse;
                        checkMessage += "</br>当前规则库版本: " + currentRuleVersion + " 最新官网规则库版本: " + newRuleVersion + "</br>当前安全库版本过低请及时升级到最新版本.";
                    } else {
                        checkMessage += "</br>当前规则库版本: " + currentRuleVersion + " 最新官网规则库版本: " + newRuleVersion + "</br>当前安全库版本已是最新版本.";
                    }
                }
            } else {
                checkStatusMsg = check;
                checkMessage += "当前OA版本为：" + ecversion + "</br> 当前补丁包版本：" + currentVersion + " 最新官网补丁包版本: " + newOANowVersion
                        + "</br>无法检测到官网补丁包版本,请人工确认." + "</br>当前规则库版本: "
                        + currentRuleVersion + " 最新官网规则库版本: " + newRuleVersion + "</br>无法检测到官网规则库版本,请人工确认.";
            }

            checkMessage += "</br> 官网安全补丁包地址： https://www.weaver.com.cn/cs/securityDownload.html" +
                    "</br> 若存在当前安全补丁包已是最新安全补丁包且仍存在相关扫描不通过的情况，请重新手动更新官网的安全补丁包";


        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>

    </tr>

    <tr>

        <td style="text-align:center;">安全包生效性检测</td>
        <%
            if (xssutil.enableFirewall()) {
                checkStatusMsg = pass;
                checkMessage = "已开启安全包防护！";
            } else {
                checkStatusMsg = refuse;
                checkMessage = "未开启安全包防护。请检查：" + nextLine +
                        "step1 " + nextLine +
                        "检查WEB-INF/web.xml文件，是否存在添加如下代码 且未被 &lt;!-- 注释\n" + nextLine +
                        "&lt;filter&gt;\n" + nextLine +
                        "&lt;filter-name&gt;SecurityFilter&lt;/filter-name&gt;\n" + nextLine +
                        "&lt;filter-class&gt;weaver.filter.SecurityFilter&lt;/filter-class&gt;\n" + nextLine +
                        "&lt;/filter&gt;\n" + nextLine +
                        "&lt;filter-mapping&gt;\n" + nextLine +
                        "&lt;filter-name&gt;SecurityFilter&lt;/filter-name&gt;\n" + nextLine +
                        "&lt;url-pattern&gt;/*&lt;/url-pattern&gt;\n" + nextLine +
                        "&lt;/filter-mapping&gt;" + nextLine +
                        "如不存在请添加 完成之后重启" + nextLine +
                        ">>>>>>>>>>>>>>>若step1 未能解决你的问题>>>>>>>>>>>>>>>>>>>" + nextLine +
                        "step2 备份并删除 /ecology/WEB-INF/weaver_security_config.xml" + nextLine +
                        "之后重启（需要先更新最新安全包）" + nextLine +
                        ">>>>>>>>>>>>>>>若step 1 与 step 2 都不能解决你的问题>>>>>>>>>>>>>>>>>>>>>>>>>>" + nextLine +
                        "请提交流程到泛微总部系统安全组";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>

    </tr>

    <tr>
        <td style="text-align:center;">RASP安全防护模块检测</td>
        <%
            boolean isRaspPass = false;
            Integer checkJarStatus = 0;
            long jarVersion = 0l;
            String classPath = "com.baidu.openrasp.Agent";
            String jarPath = null;
            try{
                Object o = Class.forName(classPath).newInstance();
                jarPath = o.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
                checkStatusMsg = refuse;
                try{
                    jarVersion = getRaspVersion(jarPath);
                    if(jarVersion >= 2000003000L){
                        checkJarStatus = 1;
                        checkStatusMsg = pass;
                        isRaspPass = true;
                        checkMessage = "可靠的RASP包版本!版本："+jarVersion;
                    }
                    if (checkJarStatus == 0) {
                        checkStatusMsg = refuse;
                        checkMessage = "<br/>当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本： "+jarVersion+"，请点击<a href='https://www.weaver.com.cn/cs/securityDownload.html' target='_blank'>RASP防护模块升级包</a>下载升级包升级。</br>";
                    }
                } catch (Exception e){
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion+"</br>";
                }
            }catch(Exception e){
                new weaver.filter.XssUtil().writeError(e);
                checkStatusMsg = refuse;
                checkMessage = "未检测到RASP防护模块。请点击<a href='https://www.weaver.com.cn/cs/securityDownload.html' target='_blank'>RASP防护模块安装包</a>下载安装包进行安装。</br>";
            }


        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>
    <%if(isRaspPass){%>
    <tr>
        <td style="text-align:center;">RASP安全防护模块规则库检测</td>
        <%
            try{
                File officaljs = new File(GCONST.getRootPath()+File.separator+"WEB-INF"+File.separator+"securityRule"+File.separator+"Rasp"+File.separator+"official.js");
                checkStatusMsg = refuse;
                try{

                    if(officaljs.exists()){
                        checkJarStatus = 1;
                        checkStatusMsg = pass;
                        checkMessage = "RASP防护模块规则库文件正常。";
                    }else{
                        checkStatusMsg = refuse;
                        checkMessage = "<br/>规则库文件("+officaljs.getAbsolutePath()+")不存在，请点击<a href='https://www.weaver.com.cn/cs/securityDownload.html>' target='_blank'>RASP防护模块升级包</a>下载升级包升级。</br>";
                    }
                } catch (Exception e){
                    checkMessage = "规则库文件路径:"+officaljs.getAbsolutePath();
                }
            }catch(Exception e){
                new weaver.filter.XssUtil().writeError(e);
                checkStatusMsg = refuse;
                checkMessage = "未检测到RASP防护模块。请点击<a href='https://www.weaver.com.cn/cs/securityDownload.html>' target='_blank'>RASP防护模块安装包</a>下载安装包进行安装。</br>";
            }


        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>
    <%}%>

    <tr>
        <td style="text-align:center;">CommonCollection包版本检测</td>
        <%

            checkJarStatus = 0;
            jarVersion = 0l;
            classPath = "/org/apache/commons/collections/CollectionUtils.class";
            jarPath = this.getClass().getResource(classPath).getPath();

            try{
                jarVersion = getVersion(classPath);

                if (jarVersion >= 3002002000L) {
                    checkJarStatus = 1;
                    checkStatusMsg = pass;
                    checkMessage = "可靠的CommonCollection包版本!版本："+jarVersion;
                }

                if (checkJarStatus == 0) {
                    checkStatusMsg = refuse;
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
                }
            } catch (Exception e){
                checkStatusMsg = refuse;
                checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
            }

        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>

    <tr>
        <td style="text-align:center;">CommonFileUpload包版本检测</td>
        <%
            checkJarStatus = 0;
            jarVersion = 0l;
            classPath = "/org/apache/commons/fileupload/DiskFileUpload.class";
            jarPath = this.getClass().getResource(classPath).getPath();

            try{
                jarVersion = getVersion(classPath);

                if (jarVersion >= 1005000000L) {
                    checkJarStatus = 1;
                    checkStatusMsg = pass;
                    checkMessage = "可靠的CommonFileUpload包版本!版本："+jarVersion;
                }

                if (checkJarStatus == 0) {
                    checkStatusMsg = refuse;
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
                }
            } catch (Exception e){
                checkStatusMsg = refuse;
                checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>

    <tr>
        <td style="text-align:center;">XStream包版本检测</td>
        <%
            checkJarStatus = 0;
            classPath = "/com/thoughtworks/xstream/XStream.class";
            jarPath = this.getClass().getResource(classPath).getPath();
            jarVersion = 0l;
            try{
                jarVersion = getVersion(classPath);

                if (jarVersion >= 1004020000L) {
                    checkJarStatus = 1;
                    checkStatusMsg = pass;
                    checkMessage = "可靠的xstream包版本!版本："+jarVersion;
                }

                if (checkJarStatus == 0) {
                    checkStatusMsg = refuse;
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
                }
            } catch (Exception e){
                checkStatusMsg = refuse;
                checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>

    <tr>
        <td style="text-align:center;">FastJson包版本检测</td>
        <%
            checkJarStatus = 0;
            jarVersion = 0l;
            classPath = "/com/alibaba/fastjson/JSONObject.class";
            jarPath = this.getClass().getResource(classPath).getPath();
            String vPath = "META-INF/maven/com.alibaba/fastjson/pom.properties";
            String preStr = "version";
            String mark = "=";

            try{
                jarVersion = getSpecialJarVersion(classPath,vPath,preStr,mark);

                if (jarVersion >= 1002083000L) {
                    checkJarStatus = 1;
                    checkStatusMsg = pass;
                    checkMessage = "可靠的fastjson包版本!版本："+jarVersion;
                }

                if (checkJarStatus == 0) {
                    checkStatusMsg = refuse;
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 ";
                }
            } catch (Exception e){
                checkStatusMsg = refuse;
                checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>

    <tr>
        <td style="text-align:center;">Jackson包版本检测</td>
        <%
            checkJarStatus = 0;
            classPath = "/com/fasterxml/jackson/databind/util/BeanUtil.class";

            jarVersion = 0l;
            try{
                jarPath = this.getClass().getResource(classPath).getPath();
                jarVersion = getVersion(classPath);
                if (jarVersion >= 2014001000L) {
                    checkJarStatus = 1;
                    checkStatusMsg = pass;
                    checkMessage = "可靠的Jackson包版本!版本："+jarVersion;
                }

                if (checkJarStatus == 0) {
                    checkStatusMsg = refuse;
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
                }
            } catch (Exception e){
                checkStatusMsg = refuse;
                checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>
    <tr>
        <td style="text-align:center;">postgresql包版本检测</td>
        <%
            checkJarStatus = 0;
            classPath = "/org/postgresql/core/Encoding.class";
            jarVersion = 0l;
            try{
                jarPath = this.getClass().getResource(classPath).getPath();
                jarVersion = getVersion(classPath);
                if (jarVersion >= 42005001000L) {
                    checkJarStatus = 1;
                    checkStatusMsg = pass;
                    checkMessage = "可靠的postgresql包版本!版本："+jarVersion;
                }

                if (checkJarStatus == 0) {
                    checkStatusMsg = refuse;
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
                }
            } catch (Exception e){
                checkStatusMsg = refuse;
                checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>

    <tr>
        <td style="text-align:center;">dubbo包版本检测</td>
        <%
            checkJarStatus = 0;
            classPath = "/org/apache/dubbo/rpc/RpcContext.class";
            jarVersion = 0l;
            try{
                jarPath = this.getClass().getResource(classPath).getPath();
                jarVersion = getVersion(classPath);
                if (jarVersion >= 2007002200L) {
                    checkJarStatus = 1;
                    checkStatusMsg = pass;
                    checkMessage = "可靠的dubbo包版本!版本："+jarVersion;
                }

                if (checkJarStatus == 0) {
                    checkStatusMsg = refuse;
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
                }
            } catch (Exception e){
                checkStatusMsg = refuse;
                checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion + "</br> 请清理之后再手动更新官网最新安全补丁包 </br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>

    <tr>
        <td style="text-align:center;">log4j包版本检测</td>
        <%
            checkJarStatus = 0;
            classPath = "/org/apache/logging/log4j/core/lookup/JndiLookup.class";
            //classPath = "/org/apache/log4j/ConsoleAppender.class";
            jarVersion = 0l;
            try{
                jarPath = this.getClass().getResource(classPath).getPath();
                checkStatusMsg = "未判断";
                try{
                    jarVersion = getVersion(classPath);
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion+"</br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
                } catch (Exception e){
                    checkMessage = "当前的依赖路径为:"+jarPath.split("!")[0] + "<br/>版本："+jarVersion+"</br> ps:此处如果依赖路径中包含%[数字+字母]之类的乱码的情况证明该依赖中包含中文路径</br> 包含中文路径的依赖请直接删除";
                }
            }catch(Exception e){
                checkStatusMsg = pass;
                checkMessage = "未找到相关依赖！"+classPath;
            }


        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>


    <tr>

        <td style="text-align:center;">synccache.jsp 是否是安全版本</td>
        <%
            File file = new File(xssutil.getRootPath() + "synccache.jsp");
            BufferedReader reader1 = null;

            try {
                if (file.exists()) {
                    reader1 = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    // 一次读入一行，直到读入null为文件结束
                    while ((tempString = reader1.readLine()) != null) {
                        // 显示行号
                        if (tempString.toLowerCase().contains("SerialKiller".toLowerCase())) {
                            checkStatusMsg = pass;
                            checkMessage = "为安全的synccache.jsp版本.";
                            break;
                        } else {
                            checkStatusMsg = refuse;
                            checkMessage = "为不安全的synccache.jsp版本,请更新最新官网安全补丁包,";
                        }
                    }
                } else {
                    checkStatusMsg = pass;
                    checkMessage = "非集群环境无该风险";
                }


            } catch (IOException e) {
                checkStatusMsg = check;
                checkMessage = "打开文件异常请人工检测.";
            } finally {
                try {
                    reader1.close();
                } catch (Exception e) {

                }
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>
    <tr>
        <td style="text-align:center;">云商店安全修复检测</td>
        <%
            File file2 = new File(xssutil.getRootPath() + File.separatorChar + "cloudstore"+File.separatorChar+"system"+File.separatorChar+"GoToCloudstore.jsp");
            BufferedReader reader2 = null;

            try {
                if (file2.exists()) {
                    reader2 = new BufferedReader(new FileReader(file2));
                    String tempString = null;
                    // 一次读入一行，直到读入null为文件结束
                    while ((tempString = reader2.readLine()) != null) {
                        // 显示行号
                        if (tempString.toLowerCase().contains("daiyingfeng".toLowerCase())) {
                            checkStatusMsg = refuse;
                            checkMessage = "未修复请及时升级最新安全补丁包.";
                            break;
                        } else {
                            checkStatusMsg = pass;
                            checkMessage = "已修复.";
                        }
                    }
                } else {
                    checkStatusMsg = pass;
                    checkMessage = "已修复.";
                }
            } catch (IOException e) {
                checkStatusMsg = check;
                checkMessage = "检测异常需人工检测.";
            } finally {
                try {
                    if(reader2!=null)
                        reader2.close();
                } catch (Exception e) {

                }
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>

    <tr>
        <td style="text-align:center;">密钥安全检测</td>
        <%

            try {
                boolean result = rs.executeSql("select * from MobilemodeProperties where prop_key = 'security.key'");
                String rand = null;
                boolean hasData = false;
                if(rs.next()){
                    rand = rs.getString("prop_value");
                    hasData = true;
                }
                if (result && hasData) {
                    if(rand == null || "".equals(rand.trim()) || "null".equalsIgnoreCase(rand.trim())) {
                        checkStatusMsg = refuse;
                        checkMessage = "未修复, 请及时升级最新安全补丁包.";
                    }else {
                        checkStatusMsg = pass;
                        checkMessage = "已修复.";
                    }
                }else{
                    BaseBean bb = new BaseBean();
                    File file3 = new File(GCONST.getRootPath() + File.separatorChar + "WEB-INF"+File.separatorChar+"prop"+File.separatorChar+"mobilemode.properties");
                    String securityKeys = bb.getPropValue("mobilemode", "security.key");
                    if (!file3.exists()) {
                        checkStatusMsg = pass;
                        checkMessage = "已修复.";
                    } else if (securityKeys == null || "".equals(securityKeys) || "null".equalsIgnoreCase(securityKeys)) {
                        checkStatusMsg = refuse;
                        checkMessage = "未修复，请及时升级最新安全补丁包.";
                    } else {
                        checkStatusMsg = pass;
                        checkMessage = "已修复.";
                    }
                }
            } catch (Exception e) {
                checkStatusMsg = check;
                checkMessage = "检测异常需人工检测.";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>
    <%if("E9".equalsIgnoreCase(xssutil.getEcVersion())){%>
    <%String suffix = new BaseBean().getPropValue("doc_upload_suffix_limit", "upload_suffix");
        if(suffix!=null && !"".equalsIgnoreCase(suffix)){
    %>
    <tr>
        <td style="text-align:center;">文件上传类型格式检测</td>
        <%

            try {
                boolean result = true;
                if("*.*".equalsIgnoreCase(suffix)){
                    result = false;
                }
                if (result) {
                    checkStatusMsg = pass;
                    checkMessage = "已修复(配置文件：/ecology/WEB-INF/prop/doc_upload_suffix_limit.properties).允许上传的文件格式："+suffix;
                }else{
                    checkStatusMsg = refuse;
                    checkMessage = "修改配置文件：/ecology/WEB-INF/prop/doc_upload_suffix_limit.properties<br/>" +
                            "<br/>" +
                            "请在以上配置文件中修改为允许上传的文件类型，建议将upload_suffix的值设置为以下类型（如有其他类型需要添加，请自行在该文件后面追加）：<br/>" +
                            "*.png;*.jpg;*.gif;*.doc;*.docx;*.pdf;*.xls;*.xlsx;*.ppt;*.pptx;*.txt;*.zip;*.rar;*.log;*.csv;*.ttf;*.license;*.wewf";
                }
            } catch (Exception e) {
                checkStatusMsg = check;
                checkMessage = "检测异常需人工检测.";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>
    <%
            }
        }%>
    <tr>
        <td style="text-align:center;">DB恢复参数检测(信创环境请忽略此项检测，自行做好数据库定时备份)</td>
        <%

            try {
                if("mysql".equalsIgnoreCase(rs.getDBType())){
                    boolean result = rs.executeSql("SELECT @@log_bin");
                    if(rs.next()){
                        int r = rs.getInt(1);
                        if(r == 1){
                            checkStatusMsg = pass;
                            checkMessage = "检查通过.";
                        }else{
                            checkStatusMsg = refuse;
                            checkMessage = "检查不通过, 请按以下步骤处理：<br/>修改数据库参数文件，增加参数重启数据库即可：<br/>" +
                                    "增加到[mysqld]下方<br/>" +
                                    "log-bin=mysql-bin<br/>" +
                                    "<br/>" +
                                    "linux参数文件名为my.cnf 默认在/etc/my.cnf<br/>" +
                                    "windows参数文件名为my.cnf，在数据库安装的路径下 ";
                        }
                    }else{
                        checkStatusMsg = refuse;
                        checkMessage = "检查不通过, 请按以下步骤处理：<br/>修改数据库参数文件，增加参数重启数据库即可：<br/>" +
                                "增加到[mysqld]下方<br/>" +
                                "log-bin=mysql-bin<br/>" +
                                "<br/>" +
                                "linux参数文件名为my.cnf 默认在/etc/my.cnf<br/>" +
                                "windows参数文件名为my.cnf，在数据库安装的路径下 ";
                    }
                }else if("oracle".equalsIgnoreCase(rs.getDBType())){
                    boolean result = rs.executeSql("select name,value from v$parameter where lower(name) in ('undo_retention') order by 1");
                    if(rs.next()){
                        int r = rs.getInt("value");
                        if(r >= 86400){
                            checkStatusMsg = pass;
                            checkMessage = "检查通过.";
                        }else{
                            checkStatusMsg = refuse;
                            checkMessage = "检查不通过, 请执行以下sql语句进行修复：<br/>alter system set undo_retention=86400 sid='*', 重启OA服务。";
                        }
                    }else{
                        checkStatusMsg = refuse;
                        checkMessage = "检查不通过, 请执行以下sql语句进行修复：<br/>alter system set undo_retention=86400 sid='*', 重启OA服务。";
                    }
                }else if("sqlserver".equalsIgnoreCase(rs.getDBType())){
                    String dburl = rs.getPropValue("weaver","ecology.url");
                    String dbname = "";
                    if(dburl!=null&&dburl.contains("DatabaseName=")){
                        dbname = dburl.substring(dburl.lastIndexOf("=")+1);
                    }
                    boolean result = rs.executeSql("select recovery_model_desc from  sys.databases where name='"+dbname+"'");
                    if(rs.next()){
                        String r = rs.getString("recovery_model_desc");
                        if("full".equalsIgnoreCase(r)){
                            checkStatusMsg = pass;
                            checkMessage = "检查通过.";
                            rs.executeSql("select 7,'数据库备份检查',case when cnt>=1 then  '检查通过' else '检查不通过,需要在数据库上配置定时任务执行数据库备份' end,'数据库最近备份:'+ convert(varchar,backupdate,25) ,getdate()\n" +
                                    "    from (\n" +
                                    "         SELECT sum(1) cnt,MAX(backup_finish_date) backupdate\n" +
                                    "\t       FROM msdb.dbo.backupmediafamily\n" +
                                    "\t\t\tINNER JOIN msdb.dbo.backupset ON msdb.dbo.backupmediafamily.media_set_id = msdb.dbo.backupset.media_set_id\n" +
                                    "\t\t\tWHERE msdb.dbo.backupset.type = 'D'\n" +
                                    "\t\t\tand backup_finish_date>=GETDATE()-2\n" +
                                    "\t\t\tand database_name='"+dbname+"'\n" +
                                    "\t\t\t) a");
                            if(rs.next()){
                                String s = rs.getString(3);
                                if("检查通过".equalsIgnoreCase(s)){
                                    checkStatusMsg = pass;
                                    checkMessage = "检查通过.";
                                }else{
                                    checkStatusMsg = refuse;
                                    checkMessage = s;
                                }
                            }
                        }else{
                            checkStatusMsg = refuse;
                            checkMessage = "检查不通过, 请执行以下sql语句进行修复：<br/>alter database ecology set recovery full , 重启OA服务。";
                        }
                    }else{
                        checkStatusMsg = refuse;
                        checkMessage = "检查不通过, 请执行以下sql语句进行修复：<br/>alter database ecology set recovery full , 重启OA服务。";
                    }
                }else{
                    checkStatusMsg = refuse;
                    checkMessage = "不支持检测的数据库类型："+rs.getDBType();
                }

            } catch (Exception e) {
                checkStatusMsg = check;
                checkMessage = "检测异常需人工检测.";
            }
        %>
        <td style="text-align:center;"><%=checkStatusMsg%>
        </td>
        <td><%=checkMessage%>
        </td>
    </tr>

    </tbody>
</table>

</body>
</html>

<%!

    public boolean checkSql() {
        try {
            ClassLoaderManager clm = ClassLoaderManager.getInstance();
            Class aClass = clm.loadClass("weaver.security.agentRules.utils.AgentCheckUtil");
            Object invoke = aClass.getMethod("checkSqlProtect").invoke(null);
            if (invoke instanceof Boolean) {
                return (Boolean) invoke;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean checkWebShellProtect() {
        try {
            ClassLoaderManager clm = ClassLoaderManager.getInstance();
            Class aClass = clm.loadClass("weaver.security.agentRules.utils.AgentCheckUtil");
            Object invoke = aClass.getMethod("checkWebShellProtect").invoke(null);
            if (invoke instanceof Boolean) {
                return (Boolean) invoke;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private long getVersion(String fileuploadPath) throws IOException {
        String path = this.getClass().getResource(fileuploadPath).getPath();
        if (path == null) {
            return -1;
        }

        Properties props = System.getProperties();
        String Osname = props.getProperty("os.name");
        weaver.filter.XssUtil util = new weaver.filter.XssUtil();
        File weblogicFile = new File(util.getRootPath() + "WEB-INF/weblogic.xml");
        if (!weblogicFile.exists()) {
            if (Osname.contains("Windows")) {
                path = path.substring("file:/".length(), path.indexOf("jar") + "jar".length());
            } else {
                path = path.substring("file:".length(), path.indexOf("jar") + "jar".length());
            }
        } else {
            path = path.substring(0,path.indexOf("jar") + "jar".length());
        }
        JarFile jarFileFileupload = new JarFile(path);
        long version = 0;
        Enumeration<JarEntry> enume = jarFileFileupload.entries();

        while (enume.hasMoreElements()) {
            JarEntry entry = enume.nextElement();
            if ("META-INF/MANIFEST.MF".equals(entry.getName())) {
                InputStream input = jarFileFileupload.getInputStream(entry);
                BufferedReader readerMF = new BufferedReader(new InputStreamReader(input));
                String line = readerMF.readLine();
                while (null != line) {
                    if (line.contains("Implementation-Version:")) {
                        String versionNow = line.substring(line.lastIndexOf("Implementation-Version:") + "Implementation-Version:".length());
                        long versionNowInt = 0;
                        String[] tmps = versionNow.trim().split("\\.");
                        if (1 == tmps.length) {

                            versionNowInt = Long.parseLong(tmps[0] + "000000000");
                        } else if (2 == tmps.length) {
                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + "000000");
                        } else if (3 == tmps.length) {
                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }

                            int c = 3 - tmps[2].length();
                            while (0 < c) {
                                tmps[2] = "0" + tmps[2];
                                c--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + tmps[2] + "000");
                        } else if (4 == tmps.length) {

                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }

                            int c = 3 - tmps[2].length();
                            while (0 < c) {
                                tmps[2] = "0" + tmps[2];
                                c--;
                            }

                            int d = 3 - tmps[3].length();
                            while (0 < d) {
                                tmps[3] = "0" + tmps[3];
                                d--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + tmps[2] + tmps[3]);
                        }
                        return versionNowInt;
                    }
                    line = readerMF.readLine();
                }
                break;
            }
        }
        return 0;
    }

    private long getRaspVersion(String path) throws IOException {
        Properties props = System.getProperties();
        String Osname = props.getProperty("os.name");
        weaver.filter.XssUtil util = new weaver.filter.XssUtil();
        File weblogicFile = new File(util.getRootPath() + "WEB-INF/weblogic.xml");
        if (!weblogicFile.exists()) {
            if (Osname.contains("Windows")) {
                path = path.substring("/".length());
            }
        } else {
            path = path.substring(0,path.indexOf("jar") + "jar".length());
        }
        JarFile jarFileFileupload = new JarFile(path);
        long version = 0;
        Enumeration<JarEntry> enume = jarFileFileupload.entries();

        while (enume.hasMoreElements()) {
            JarEntry entry = enume.nextElement();
            if ("META-INF/MANIFEST.MF".equals(entry.getName())) {
                InputStream input = jarFileFileupload.getInputStream(entry);
                BufferedReader readerMF = new BufferedReader(new InputStreamReader(input));
                String line = readerMF.readLine();
                while (null != line) {
                    if (line.contains("Project-Version:")) {
                        String versionNow = line.substring(line.lastIndexOf("Project-Version:") + "Project-Version:".length());
                        long versionNowInt = 0;
                        String[] tmps = versionNow.trim().split("\\.");
                        if (1 == tmps.length) {

                            versionNowInt = Long.parseLong(tmps[0] + "000000000");
                        } else if (2 == tmps.length) {
                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + "000000");
                        } else if (3 == tmps.length) {
                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }

                            int c = 3 - tmps[2].length();
                            while (0 < c) {
                                tmps[2] = "0" + tmps[2];
                                c--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + tmps[2] + "000");
                        } else if (4 == tmps.length) {

                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }

                            int c = 3 - tmps[2].length();
                            while (0 < c) {
                                tmps[2] = "0" + tmps[2];
                                c--;
                            }

                            int d = 3 - tmps[3].length();
                            while (0 < d) {
                                tmps[3] = "0" + tmps[3];
                                d--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + tmps[2] + tmps[3]);
                        }
                        return versionNowInt;
                    }
                    line = readerMF.readLine();
                }
                break;
            }
        }
        return 0;
    }

    private long getSpecialJarVersion(String fileuploadPath, String vPath, String preStr, String mark) throws IOException {
        String path = this.getClass().getResource(fileuploadPath).getPath();
        if (path == null) {
            return -1;
        }

        Properties props = System.getProperties();
        String Osname = props.getProperty("os.name");
        weaver.filter.XssUtil util = new weaver.filter.XssUtil();
        File weblogicFile = new File(util.getRootPath() + "WEB-INF/weblogic.xml");
        if (!weblogicFile.exists()) {
            if (Osname.contains("Windows")) {
                path = path.substring("file:/".length(), path.indexOf("jar") + "jar".length());
            } else {
                path = path.substring("file:".length(), path.indexOf("jar") + "jar".length());
            }
        } else {
            path = path.substring(0,path.indexOf("jar") + "jar".length());
        }
        JarFile jarFileFileupload = new JarFile(path);
        long version = 0;
        Enumeration<JarEntry> enume = jarFileFileupload.entries();

        while (enume.hasMoreElements()) {
            JarEntry entry = enume.nextElement();
            if (vPath.equals(entry.getName())) {
                InputStream input = jarFileFileupload.getInputStream(entry);
                BufferedReader readerMF = new BufferedReader(new InputStreamReader(input));
                String line = readerMF.readLine();
                while (null != line) {
                    if (line.contains(preStr)) {
                        String versionNow = line.split(mark)[1].trim();
                        long versionNowInt = 0;
                        String[] tmps = versionNow.trim().split("\\.");
                        if (1 == tmps.length) {

                            versionNowInt = Long.parseLong(tmps[0] + "000000000");
                        } else if (2 == tmps.length) {
                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + "000000");
                        } else if (3 == tmps.length) {
                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }

                            int c = 3 - tmps[2].length();
                            while (0 < c) {
                                tmps[2] = "0" + tmps[2];
                                c--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + tmps[2] + "000");
                        } else if (4 == tmps.length) {

                            int a = 3 - tmps[1].length();
                            while (0 < a) {
                                tmps[1] = "0" + tmps[1];
                                a--;
                            }

                            int c = 3 - tmps[2].length();
                            while (0 < c) {
                                tmps[2] = "0" + tmps[2];
                                c--;
                            }

                            int d = 3 - tmps[3].length();
                            while (0 < d) {
                                tmps[3] = "0" + tmps[3];
                                d--;
                            }
                            versionNowInt = Long.parseLong(tmps[0] + tmps[1] + tmps[2] + tmps[3]);
                        }
                        return versionNowInt;
                    }
                    line = readerMF.readLine();
                }
                break;
            }
        }
        return 0;
    }

%>
