/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.StringValue;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.protobuf.support.ProtobufUtils;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.MapValue;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.ThrowablePB;

public class GenericProtobufJsonObjectInput
implements ObjectInput {
    private final BufferedReader reader;

    public GenericProtobufJsonObjectInput(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public boolean readBool() throws IOException {
        return this.read(BoolValue.class).getValue();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read(Int32Value.class).getValue();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.read(Int32Value.class).getValue();
    }

    @Override
    public int readInt() throws IOException {
        return this.read(Int32Value.class).getValue();
    }

    @Override
    public long readLong() throws IOException {
        return this.read(Int64Value.class).getValue();
    }

    @Override
    public float readFloat() throws IOException {
        return this.read(FloatValue.class).getValue();
    }

    @Override
    public double readDouble() throws IOException {
        return this.read(DoubleValue.class).getValue();
    }

    @Override
    public String readUTF() throws IOException {
        return this.read(StringValue.class).getValue();
    }

    @Override
    public byte[] readBytes() throws IOException {
        return this.read(BytesValue.class).getValue().toByteArray();
    }

    @Override
    public Object readObject() {
        throw new UnsupportedOperationException("Provide the protobuf message type you want to read.");
    }

    @Override
    public <T> T readObject(Class<T> cls) throws IOException {
        return this.read(cls);
    }

    @Override
    public <T> T readObject(Class<T> cls, Type type) throws IOException {
        return this.readObject(cls);
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null || line.trim().length() == 0) {
            throw new EOFException();
        }
        return line;
    }

    private <T> T read(Class<T> cls) throws IOException {
        if (!ProtobufUtils.isSupported(cls)) {
            throw new IllegalArgumentException("This serialization only support google protobuf entity, the class is :" + cls.getName());
        }
        String json = this.readLine();
        return ProtobufUtils.deserializeJson(json, cls);
    }

    @Override
    public Throwable readThrowable() throws IOException {
        String json = this.readLine();
        ThrowablePB.ThrowableProto throwableProto = ProtobufUtils.deserializeJson(json, ThrowablePB.ThrowableProto.class);
        return ProtobufUtils.convertToException(throwableProto);
    }

    @Override
    public Map<String, Object> readAttachments() throws IOException, ClassNotFoundException {
        String json = this.readLine();
        Map<String, String> attachments = ProtobufUtils.deserializeJson(json, MapValue.Map.class).getAttachmentsMap();
        HashMap<String, Object> genericAttachments = new HashMap<String, Object>();
        attachments.forEach((k, v) -> genericAttachments.put((String)k, v));
        return genericAttachments;
    }

    @Override
    public Object readEvent() throws IOException, ClassNotFoundException {
        String eventData = this.readUTF();
        if (eventData.equals("H")) {
            eventData = CommonConstants.HEARTBEAT_EVENT;
        }
        return eventData;
    }
}

