/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.grizzly;

import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractClient;
import org.apache.dubbo.remoting.transport.grizzly.GrizzlyChannel;
import org.apache.dubbo.remoting.transport.grizzly.GrizzlyCodecAdapter;
import org.apache.dubbo.remoting.transport.grizzly.GrizzlyHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class GrizzlyClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(GrizzlyClient.class);
    private TCPNIOTransport transport;
    private volatile Connection<?> connection;

    public GrizzlyClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    @Override
    protected void doOpen() throws Throwable {
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new GrizzlyCodecAdapter(this.getCodec(), this.getUrl(), this));
        filterChainBuilder.add((Filter)new GrizzlyHandler(this.getUrl(), this));
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        ThreadPoolConfig config = builder.getWorkerThreadPoolConfig();
        config.setPoolName("DubboClientHandler").setQueueLimit(-1).setCorePoolSize(0).setMaxPoolSize(Integer.MAX_VALUE).setKeepAliveTime(60L, TimeUnit.SECONDS);
        ((TCPNIOTransportBuilder)builder.setTcpNoDelay(true).setKeepAlive(true).setConnectionTimeout(this.getConnectTimeout())).setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance());
        this.transport = builder.build();
        this.transport.setProcessor((Processor)filterChainBuilder.build());
        this.transport.start();
    }

    @Override
    protected void doConnect() throws Throwable {
        this.connection = (Connection)this.transport.connect((SocketAddress)this.getConnectAddress()).get((long)this.getUrl().getPositiveParameter("timeout", 1000), TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doDisConnect() throws Throwable {
        try {
            GrizzlyChannel.removeChannelIfDisconnected(this.connection);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    @Override
    protected void doClose() throws Throwable {
        try {
            this.transport.stop();
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    @Override
    protected Channel getChannel() {
        Connection<?> c = this.connection;
        if (c == null || !c.isOpen()) {
            return null;
        }
        return GrizzlyChannel.getOrAddChannel(c, this.getUrl(), this);
    }
}

