/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLSubPartitionBy;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLLoopStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlForceIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlIgnoreIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUseIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.ConditionValue;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCursorDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareConditionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareHandlerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlIterateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlLeaveStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlRepeatStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlSelectIntoStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlWhileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExtractExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlIntervalExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlMatchAgainstExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlUserName;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAlterColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableCharacter;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableDiscardTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableImportTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableOption;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAnalyzeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlBinlogStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCommitStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDescribeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExecuteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHelpStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHintStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadDataInFileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadXmlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLockTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlOptimizeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlResetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRollbackStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetCharSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetNamesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetPasswordStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowAuthorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinaryLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCharacterSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCollationStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowContributorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTriggerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateViewStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEngineStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEnginesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowErrorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowGrantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowIndexesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowKeysStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowOpenTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPluginsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPrivilegesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcessListStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfilesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowRelayLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveHostsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTableStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTriggersStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowVariantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowWarningsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStartTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByList;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnlockTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;
import java.util.Map;

public class MySqlOutputVisitor
extends SQLASTOutputVisitor
implements MySqlASTVisitor {
    public MySqlOutputVisitor(Appendable appender) {
        super(appender);
        this.dbType = "mysql";
    }

    @Override
    public boolean visit(SQLSelectQueryBlock select) {
        if (select instanceof MySqlSelectQueryBlock) {
            return this.visit((MySqlSelectQueryBlock)select);
        }
        return super.visit(select);
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        if (x.getOrderBy() != null) {
            x.getOrderBy().setParent(x);
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        int size = x.getHintsSize();
        for (int i = 0; i < size; ++i) {
            SQLCommentHint hint = x.getHints().get(i);
            hint.accept(this);
            this.print(' ');
        }
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (4 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCTROW " : "distinctrow ");
        }
        if (x.isHignPriority()) {
            this.print0(this.ucase ? "HIGH_PRIORITY " : "high_priority ");
        }
        if (x.isStraightJoin()) {
            this.print0(this.ucase ? "STRAIGHT_JOIN " : "straight_join ");
        }
        if (x.isSmallResult()) {
            this.print0(this.ucase ? "SQL_SMALL_RESULT " : "sql_small_result ");
        }
        if (x.isBigResult()) {
            this.print0(this.ucase ? "SQL_BIG_RESULT " : "sql_big_result ");
        }
        if (x.isBufferResult()) {
            this.print0(this.ucase ? "SQL_BUFFER_RESULT " : "sql_buffer_result ");
        }
        if (x.getCache() != null) {
            if (x.getCache().booleanValue()) {
                this.print0(this.ucase ? "SQL_CACHE " : "sql_cache ");
            } else {
                this.print0(this.ucase ? "SQL_NO_CACHE " : "sql_no_cache ");
            }
        }
        if (x.isCalcFoundRows()) {
            this.print0(this.ucase ? "SQL_CALC_FOUND_ROWS " : "sql_calc_found_rows ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        if (x.getProcedureName() != null) {
            this.print0(this.ucase ? " PROCEDURE " : " procedure ");
            x.getProcedureName().accept(this);
            if (!x.getProcedureArgumentList().isEmpty()) {
                this.print('(');
                this.printAndAccept(x.getProcedureArgumentList(), ", ");
                this.print(')');
            }
        }
        if (x.isForUpdate()) {
            this.println();
            this.print0(this.ucase ? "FOR UPDATE" : "for update");
        }
        if (x.isLockInShareMode()) {
            this.println();
            this.print0(this.ucase ? "LOCK IN SHARE MODE" : "lock in share mode");
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        x.getName().accept(this);
        this.print(' ');
        x.getDataType().accept(this);
        if (x.getCharsetExpr() != null) {
            this.print0(this.ucase ? " CHARSET " : " charset ");
            x.getCharsetExpr().accept(this);
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            this.print(' ');
            item.accept(this);
        }
        if (x.getDefaultExpr() != null) {
            if (x.getDefaultExpr() instanceof SQLNullExpr) {
                this.print0(this.ucase ? " NULL" : " null");
            } else {
                this.print0(this.ucase ? " DEFAULT " : " default ");
                x.getDefaultExpr().accept(this);
            }
        }
        if (x.getStorage() != null) {
            this.print0(this.ucase ? " STORAGE " : " storage ");
            x.getStorage().accept(this);
        }
        if (x.getOnUpdate() != null) {
            this.print0(this.ucase ? " ON UPDATE " : " on update ");
            x.getOnUpdate().accept(this);
        }
        if (x.isAutoIncrement()) {
            this.print0(this.ucase ? " AUTO_INCREMENT" : " auto_increment");
        }
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        if (x.getAsExpr() != null) {
            this.print0(this.ucase ? " AS (" : " as (");
            x.getAsExpr().accept(this);
            this.print(')');
        }
        if (x.isSorted()) {
            this.print0(this.ucase ? " SORTED" : " sorted");
        }
        return false;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock.Limit x) {
        this.print0(this.ucase ? "LIMIT " : "limit ");
        if (x.getOffset() != null) {
            x.getOffset().accept(this);
            this.print0(", ");
        }
        x.getRowCount().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDataType x) {
        SQLCharacterDataType charType;
        this.print0(x.getName());
        if (!x.getArguments().isEmpty()) {
            this.print('(');
            this.printAndAccept(x.getArguments(), ", ");
            this.print(')');
        }
        if (Boolean.TRUE == x.getAttribute("UNSIGNED")) {
            this.print0(this.ucase ? " UNSIGNED" : " unsigned");
        }
        if (Boolean.TRUE == x.getAttribute("ZEROFILL")) {
            this.print0(this.ucase ? " ZEROFILL" : " zerofill");
        }
        if (x instanceof SQLCharacterDataType && (charType = (SQLCharacterDataType)x).getCharSetName() != null) {
            this.print0(this.ucase ? " CHARACTER SET " : " character set ");
            this.print0(charType.getCharSetName());
            if (charType.getCollate() != null) {
                this.print0(this.ucase ? " COLLATE " : " collate ");
                this.print0(charType.getCollate());
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharacterDataType x) {
        this.print0(x.getName());
        if (!x.getArguments().isEmpty()) {
            this.print('(');
            this.printAndAccept(x.getArguments(), ", ");
            this.print(')');
        }
        if (x.isHasBinary()) {
            this.print0(this.ucase ? " BINARY " : " binary ");
        }
        if (x.getCharSetName() != null) {
            this.print0(this.ucase ? " CHARACTER SET " : " character set ");
            this.print0(x.getCharSetName());
            if (x.getCollate() != null) {
                this.print0(this.ucase ? " COLLATE " : " collate ");
                this.print0(x.getCollate());
            }
        } else if (x.getCollate() != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(x.getCollate());
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock.Limit x) {
    }

    @Override
    public void endVisit(MySqlTableIndex x) {
    }

    @Override
    public boolean visit(MySqlTableIndex x) {
        this.print0(this.ucase ? "INDEX" : "index");
        if (x.getName() != null) {
            this.print(' ');
            x.getName().accept(this);
        }
        if (x.getIndexType() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getIndexType());
        }
        this.print('(');
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(MySqlCreateTableStatement x) {
        int size;
        this.print0(this.ucase ? "CREATE " : "create ");
        for (SQLCommentHint hint : x.getHints()) {
            hint.accept(this);
            this.print(' ');
        }
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
            this.print0(this.ucase ? "TEMPORARY TABLE " : "temporary table ");
        } else {
            this.print0(this.ucase ? "TABLE " : "table ");
        }
        if (x.isIfNotExiists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getName().accept(this);
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if ((size = x.getTableElementList().size()) > 0) {
            this.print0(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                x.getTableElementList().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        for (Map.Entry<String, SQLObject> option : x.getTableOptions().entrySet()) {
            String key = option.getKey();
            this.print(' ');
            this.print0(this.ucase ? key : key.toLowerCase());
            if ("TABLESPACE".equals(key)) {
                this.print(' ');
                option.getValue().accept(this);
                continue;
            }
            if ("UNION".equals(key)) {
                this.print0(" = (");
                option.getValue().accept(this);
                this.print(')');
                continue;
            }
            this.print0(" = ");
            option.getValue().accept(this);
        }
        if (x.getPartitioning() != null) {
            this.println();
            x.getPartitioning().accept(this);
        }
        if (x.getTableGroup() != null) {
            this.println();
            this.print0(this.ucase ? "TABLEGROUP " : "tablegroup ");
            x.getTableGroup().accept(this);
        }
        if (x.getSelect() != null) {
            this.incrementIndent();
            this.println();
            x.getSelect().accept(this);
            this.decrementIndent();
        }
        for (SQLCommentHint hint : x.getOptionHints()) {
            this.print(' ');
            hint.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlKey x) {
    }

    @Override
    public void endVisit(MySqlPrimaryKey x) {
    }

    @Override
    public void endVisit(MysqlForeignKey x) {
    }

    @Override
    public boolean visit(MySqlKey x) {
        if (x.isHasConstaint()) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print0(this.ucase ? "KEY" : "key");
        if (x.getIndexName() != null) {
            this.print(' ');
            x.getIndexName().accept(this);
        }
        if (x.getIndexType() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getIndexType());
        }
        this.print0(" (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(MySqlPrimaryKey x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "PRIMARY KEY" : "primary key");
        if (x.getIndexType() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getIndexType());
        }
        this.print0(" (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        this.print('\'');
        String text = x.getText();
        StringBuilder buf = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\'') {
                buf.append('\'');
                buf.append('\'');
                continue;
            }
            if (ch == '\\') {
                buf.append('\\');
                buf.append('\\');
                continue;
            }
            if (ch == '\u0000') {
                buf.append('\\');
                buf.append('0');
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() != text.length()) {
            text = buf.toString();
        }
        this.print0(text);
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        int parametersSize = this.getParametersSize();
        int index = x.getIndex();
        if (index >= 0 && index < parametersSize) {
            Object param = this.getParameters().get(index);
            this.printParameter(param);
            return false;
        }
        String varName = x.getName();
        if (x.isGlobal()) {
            this.print0("@@global.");
        } else if (!(varName.startsWith("@") || varName.equals("?") || varName.startsWith("#") || varName.startsWith("$") || varName.startsWith(":"))) {
            boolean subPartitionOption = false;
            if (x.getParent() != null) {
                subPartitionOption = x.getParent().getParent() instanceof SQLSubPartitionBy;
            }
            if (!subPartitionOption) {
                this.print0("@@");
            }
        }
        for (int i = 0; i < x.getName().length(); ++i) {
            char ch = x.getName().charAt(i);
            if (ch == '\'') {
                if (x.getName().startsWith("@@") && i == 2) {
                    this.print(ch);
                    continue;
                }
                if (x.getName().startsWith("@") && i == 1) {
                    this.print(ch);
                    continue;
                }
                if (i != 0 && i != x.getName().length() - 1) {
                    this.print0("\\'");
                    continue;
                }
                this.print(ch);
                continue;
            }
            this.print(ch);
        }
        String collate = (String)x.getAttribute("COLLATE");
        if (collate != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(collate);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if ("SUBSTRING".equalsIgnoreCase(x.getMethodName())) {
            SQLExpr forExpr;
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print('.');
            }
            this.print0(x.getMethodName());
            this.print('(');
            this.printAndAccept(x.getParameters(), ", ");
            SQLExpr from = (SQLExpr)x.getAttribute("FROM");
            if (from != null) {
                this.print0(this.ucase ? " FROM " : " from ");
                from.accept(this);
            }
            if ((forExpr = (SQLExpr)x.getAttribute("FOR")) != null) {
                this.print0(this.ucase ? " FOR " : " for ");
                forExpr.accept(this);
            }
            this.print(')');
            return false;
        }
        if ("TRIM".equalsIgnoreCase(x.getMethodName())) {
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print('.');
            }
            this.print0(x.getMethodName());
            this.print('(');
            String trimType = (String)x.getAttribute("TRIM_TYPE");
            if (trimType != null) {
                this.print0(trimType);
                this.print(' ');
            }
            this.printAndAccept(x.getParameters(), ", ");
            SQLExpr from = (SQLExpr)x.getAttribute("FROM");
            if (from != null) {
                this.print0(this.ucase ? " FROM " : " from ");
                from.accept(this);
            }
            this.print(')');
            return false;
        }
        if ("CONVERT".equalsIgnoreCase(x.getMethodName()) || "CHAR".equalsIgnoreCase(x.getMethodName())) {
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print('.');
            }
            this.print0(x.getMethodName());
            this.print('(');
            this.printAndAccept(x.getParameters(), ", ");
            String charset = (String)x.getAttribute("USING");
            if (charset != null) {
                this.print0(this.ucase ? " USING " : " using ");
                this.print0(charset);
            }
            this.print(')');
            return false;
        }
        return super.visit(x);
    }

    @Override
    public void endVisit(MySqlIntervalExpr x) {
    }

    @Override
    public boolean visit(MySqlIntervalExpr x) {
        this.print0(this.ucase ? "INTERVAL " : "interval ");
        x.getValue().accept(this);
        this.print(' ');
        this.print0(this.ucase ? x.getUnit().name() : x.getUnit().name_lcase);
        return false;
    }

    @Override
    public boolean visit(MySqlExtractExpr x) {
        this.print0(this.ucase ? "EXTRACT(" : "extract(");
        this.print0(x.getUnit().name());
        this.print0(this.ucase ? " FROM " : " from ");
        x.getValue().accept(this);
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlExtractExpr x) {
    }

    @Override
    public void endVisit(MySqlMatchAgainstExpr x) {
    }

    @Override
    public boolean visit(MySqlMatchAgainstExpr x) {
        this.print0(this.ucase ? "MATCH (" : "match (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        this.print0(this.ucase ? " AGAINST (" : " against (");
        x.getAgainst().accept(this);
        if (x.getSearchModifier() != null) {
            this.print(' ');
            this.print0(this.ucase ? x.getSearchModifier().name : x.getSearchModifier().name_lcase);
        }
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlPrepareStatement x) {
    }

    @Override
    public boolean visit(MySqlPrepareStatement x) {
        this.print0(this.ucase ? "PREPARE " : "prepare ");
        x.getName().accept(this);
        this.print0(this.ucase ? " FROM " : " from ");
        x.getFrom().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlExecuteStatement x) {
    }

    @Override
    public boolean visit(MySqlExecuteStatement x) {
        this.print0(this.ucase ? "EXECUTE " : "execute ");
        x.getStatementName().accept(this);
        if (x.getParameters().size() > 0) {
            this.print0(this.ucase ? " USING " : " using ");
            this.printAndAccept(x.getParameters(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlDeleteStatement x) {
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        this.print0(this.ucase ? "DELETE " : "delete ");
        int size = x.getHintsSize();
        for (int i = 0; i < size; ++i) {
            SQLCommentHint hint = x.getHints().get(i);
            hint.accept(this);
            this.print(' ');
        }
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isQuick()) {
            this.print0(this.ucase ? "QUICK " : "quick ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? "IGNORE " : "ignore ");
        }
        if (x.getFrom() == null) {
            this.print0(this.ucase ? "FROM " : "from ");
            x.getTableSource().accept(this);
        } else {
            x.getTableSource().accept(this);
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept(this);
        }
        if (x.getUsing() != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            x.getUsing().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.incrementIndent();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlInsertStatement x) {
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        int i;
        int size;
        this.print0(this.ucase ? "INSERT " : "insert ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isDelayed()) {
            this.print0(this.ucase ? "DELAYED " : "delayed ");
        }
        if (x.isHighPriority()) {
            this.print0(this.ucase ? "HIGH_PRIORITY " : "high_priority ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? "IGNORE " : "ignore ");
        }
        if (x.isRollbackOnFail()) {
            this.print0(this.ucase ? "ROLLBACK_ON_FAIL " : "rollback_on_fail ");
        }
        this.print0(this.ucase ? "INTO " : "into ");
        x.getTableSource().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.print0(" (");
            size = x.getColumns().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print0(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(')');
            this.decrementIndent();
        }
        if (!x.getValuesList().isEmpty()) {
            this.println();
            this.printValuesList(x);
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if (x.getDuplicateKeyUpdate().size() != 0) {
            this.println();
            this.print0(this.ucase ? "ON DUPLICATE KEY UPDATE " : "on duplicate key update ");
            size = x.getDuplicateKeyUpdate().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print0(", ");
                }
                x.getDuplicateKeyUpdate().get(i).accept(this);
            }
        }
        return false;
    }

    protected void printValuesList(MySqlInsertStatement x) {
        this.print0(this.ucase ? "VALUES " : "values ");
        if (x.getValuesList().size() > 1) {
            this.incrementIndent();
        }
        int size = x.getValuesList().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(',');
                this.println();
            }
            x.getValuesList().get(i).accept(this);
        }
        if (x.getValuesList().size() > 1) {
            this.decrementIndent();
        }
    }

    @Override
    public void endVisit(MySqlLoadDataInFileStatement x) {
    }

    @Override
    public boolean visit(MySqlLoadDataInFileStatement x) {
        this.print0(this.ucase ? "LOAD DATA " : "load data ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isConcurrent()) {
            this.print0(this.ucase ? "CONCURRENT " : "concurrent ");
        }
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "INFILE " : "infile ");
        x.getFileName().accept(this);
        if (x.isReplicate()) {
            this.print0(this.ucase ? " REPLACE " : " replace ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? " IGNORE " : " ignore ");
        }
        this.print0(this.ucase ? " INTO TABLE " : " into table ");
        x.getTableName().accept(this);
        if (x.getColumnsTerminatedBy() != null || x.getColumnsEnclosedBy() != null || x.getColumnsEscaped() != null) {
            this.print0(this.ucase ? " COLUMNS" : " columns");
            if (x.getColumnsTerminatedBy() != null) {
                this.print0(this.ucase ? " TERMINATED BY " : " terminated by ");
                x.getColumnsTerminatedBy().accept(this);
            }
            if (x.getColumnsEnclosedBy() != null) {
                if (x.isColumnsEnclosedOptionally()) {
                    this.print0(this.ucase ? " OPTIONALLY" : " optionally");
                }
                this.print0(this.ucase ? " ENCLOSED BY " : " enclosed by ");
                x.getColumnsEnclosedBy().accept(this);
            }
            if (x.getColumnsEscaped() != null) {
                this.print0(this.ucase ? " ESCAPED BY " : " escaped by ");
                x.getColumnsEscaped().accept(this);
            }
        }
        if (x.getLinesStartingBy() != null || x.getLinesTerminatedBy() != null) {
            this.print0(this.ucase ? " LINES" : " lines");
            if (x.getLinesStartingBy() != null) {
                this.print0(this.ucase ? " STARTING BY " : " starting by ");
                x.getLinesStartingBy().accept(this);
            }
            if (x.getLinesTerminatedBy() != null) {
                this.print0(this.ucase ? " TERMINATED BY " : " terminated by ");
                x.getLinesTerminatedBy().accept(this);
            }
        }
        if (x.getIgnoreLinesNumber() != null) {
            this.print0(this.ucase ? " IGNORE " : " ignore ");
            x.getIgnoreLinesNumber().accept(this);
            this.print0(this.ucase ? " LINES" : " lines");
        }
        if (x.getColumns().size() != 0) {
            this.print0(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        if (x.getSetList().size() != 0) {
            this.print0(this.ucase ? " SET " : " set ");
            this.printAndAccept(x.getSetList(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlReplaceStatement x) {
    }

    @Override
    public boolean visit(MySqlReplaceStatement x) {
        this.print0(this.ucase ? "REPLACE " : "replace ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isDelayed()) {
            this.print0(this.ucase ? "DELAYED " : "delayed ");
        }
        this.print0(this.ucase ? "INTO " : "into ");
        x.getTableName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print0(" (");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(')');
        }
        if (x.getValuesList().size() != 0) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            int size = x.getValuesList().size();
            if (size == 0) {
                this.print0("()");
            } else {
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print0(", ");
                    }
                    x.getValuesList().get(i).accept(this);
                }
            }
        }
        if (x.getQuery() != null) {
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlStartTransactionStatement x) {
    }

    @Override
    public boolean visit(MySqlStartTransactionStatement x) {
        this.print0(this.ucase ? "START TRANSACTION" : "start transaction");
        if (x.isConsistentSnapshot()) {
            this.print0(this.ucase ? " WITH CONSISTENT SNAPSHOT" : " with consistent snapshot");
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        if (x.isBegin()) {
            this.print0(this.ucase ? " BEGIN" : " begin");
        }
        if (x.isWork()) {
            this.print0(this.ucase ? " WORK" : " work");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCommitStatement x) {
    }

    @Override
    public boolean visit(MySqlCommitStatement x) {
        this.print0(this.ucase ? "COMMIT" : "commit");
        if (x.isWork()) {
            this.print0(this.ucase ? " WORK" : " work");
        }
        if (x.getChain() != null) {
            if (x.getChain().booleanValue()) {
                this.print0(this.ucase ? " AND CHAIN" : " and chain");
            } else {
                this.print0(this.ucase ? " AND NO CHAIN" : " and no chain");
            }
        }
        if (x.getRelease() != null) {
            if (x.getRelease().booleanValue()) {
                this.print0(this.ucase ? " AND RELEASE" : " and release");
            } else {
                this.print0(this.ucase ? " AND NO RELEASE" : " and no release");
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlRollbackStatement x) {
    }

    @Override
    public boolean visit(MySqlRollbackStatement x) {
        this.print0(this.ucase ? "ROLLBACK" : "rollback");
        if (x.getChain() != null) {
            if (x.getChain().booleanValue()) {
                this.print0(this.ucase ? " AND CHAIN" : " and chain");
            } else {
                this.print0(this.ucase ? " AND NO CHAIN" : " and no chain");
            }
        }
        if (x.getRelease() != null) {
            if (x.getRelease().booleanValue()) {
                this.print0(this.ucase ? " AND RELEASE" : " and release");
            } else {
                this.print0(this.ucase ? " AND NO RELEASE" : " and no release");
            }
        }
        if (x.getTo() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowColumnsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowColumnsStatement x) {
        if (x.isFull()) {
            this.print0(this.ucase ? "SHOW FULL COLUMNS" : "show full columns");
        } else {
            this.print0(this.ucase ? "SHOW COLUMNS" : "show columns");
        }
        if (x.getTable() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLShowTablesStatement x) {
        if (x.isFull()) {
            this.print0(this.ucase ? "SHOW FULL TABLES" : "show full tables");
        } else {
            this.print0(this.ucase ? "SHOW TABLES" : "show tables");
        }
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowDatabasesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowDatabasesStatement x) {
        this.print0(this.ucase ? "SHOW DATABASES" : "show databases");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowWarningsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowWarningsStatement x) {
        if (x.isCount()) {
            this.print0(this.ucase ? "SHOW COUNT(*) WARNINGS" : "show count(*) warnings");
        } else {
            this.print0(this.ucase ? "SHOW WARNINGS" : "show warnings");
            if (x.getLimit() != null) {
                this.print(' ');
                x.getLimit().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowStatusStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        if (x.isGlobal()) {
            this.print0(this.ucase ? "GLOBAL " : "global ");
        }
        if (x.isSession()) {
            this.print0(this.ucase ? "SESSION " : "session ");
        }
        this.print0(this.ucase ? "STATUS" : "status");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlLoadXmlStatement x) {
    }

    @Override
    public boolean visit(MySqlLoadXmlStatement x) {
        this.print0(this.ucase ? "LOAD XML " : "load xml ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isConcurrent()) {
            this.print0(this.ucase ? "CONCURRENT " : "concurrent ");
        }
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "INFILE " : "infile ");
        x.getFileName().accept(this);
        if (x.isReplicate()) {
            this.print0(this.ucase ? " REPLACE " : " replace ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? " IGNORE " : " ignore ");
        }
        this.print0(this.ucase ? " INTO TABLE " : " into table ");
        x.getTableName().accept(this);
        if (x.getCharset() != null) {
            this.print0(this.ucase ? " CHARSET " : " charset ");
            this.print0(x.getCharset());
        }
        if (x.getRowsIdentifiedBy() != null) {
            this.print0(this.ucase ? " ROWS IDENTIFIED BY " : " rows identified by ");
            x.getRowsIdentifiedBy().accept(this);
        }
        if (x.getSetList().size() != 0) {
            this.print0(this.ucase ? " SET " : " set ");
            this.printAndAccept(x.getSetList(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(CobarShowStatus x) {
    }

    @Override
    public boolean visit(CobarShowStatus x) {
        this.print0(this.ucase ? "SHOW COBAR_STATUS" : "show cobar_status");
        return false;
    }

    @Override
    public void endVisit(MySqlKillStatement x) {
    }

    @Override
    public boolean visit(MySqlKillStatement x) {
        if (MySqlKillStatement.Type.CONNECTION.equals((Object)x.getType())) {
            this.print0(this.ucase ? "KILL CONNECTION " : "kill connection ");
        } else if (MySqlKillStatement.Type.QUERY.equals((Object)x.getType())) {
            this.print0(this.ucase ? "KILL QUERY " : "kill query ");
        }
        x.getThreadId().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlBinlogStatement x) {
    }

    @Override
    public boolean visit(MySqlBinlogStatement x) {
        this.print0(this.ucase ? "BINLOG " : "binlog ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlResetStatement x) {
    }

    @Override
    public boolean visit(MySqlResetStatement x) {
        this.print0(this.ucase ? "RESET " : "reset ");
        for (int i = 0; i < x.getOptions().size(); ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            this.print0(x.getOptions().get(i));
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateUserStatement x) {
    }

    @Override
    public boolean visit(MySqlCreateUserStatement x) {
        this.print0(this.ucase ? "CREATE USER " : "create user ");
        this.printAndAccept(x.getUsers(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlCreateUserStatement.UserSpecification x) {
    }

    @Override
    public boolean visit(MySqlCreateUserStatement.UserSpecification x) {
        x.getUser().accept(this);
        if (x.getPassword() != null) {
            this.print0(this.ucase ? " IDENTIFIED BY " : " identified by ");
            if (x.isPasswordHash()) {
                this.print0(this.ucase ? "PASSWORD " : "password ");
            }
            x.getPassword().accept(this);
        }
        if (x.getAuthPlugin() != null) {
            this.print0(this.ucase ? " IDENTIFIED WITH " : " identified with ");
            x.getAuthPlugin().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlPartitionByKey x) {
    }

    @Override
    public boolean visit(MySqlPartitionByKey x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "PARTITION BY LINEAR KEY (" : "partition by linear key (");
        } else {
            this.print0(this.ucase ? "PARTITION BY KEY (" : "partition by key (");
        }
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        this.printPartitionsCountAndSubPartitions(x);
        return false;
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock x) {
    }

    @Override
    public boolean visit(MySqlOutFileExpr x) {
        this.print0(this.ucase ? "OUTFILE " : "outfile ");
        x.getFile().accept(this);
        if (x.getCharset() != null) {
            this.print0(this.ucase ? " CHARACTER SET " : " character set ");
            this.print0(x.getCharset());
        }
        if (x.getColumnsTerminatedBy() != null || x.getColumnsEnclosedBy() != null || x.getColumnsEscaped() != null) {
            this.print0(this.ucase ? " COLUMNS" : " columns");
            if (x.getColumnsTerminatedBy() != null) {
                this.print0(this.ucase ? " TERMINATED BY " : " terminated by ");
                x.getColumnsTerminatedBy().accept(this);
            }
            if (x.getColumnsEnclosedBy() != null) {
                if (x.isColumnsEnclosedOptionally()) {
                    this.print0(this.ucase ? " OPTIONALLY" : " optionally");
                }
                this.print0(this.ucase ? " ENCLOSED BY " : " enclosed by ");
                x.getColumnsEnclosedBy().accept(this);
            }
            if (x.getColumnsEscaped() != null) {
                this.print0(this.ucase ? " ESCAPED BY " : " escaped by ");
                x.getColumnsEscaped().accept(this);
            }
        }
        if (x.getLinesStartingBy() != null || x.getLinesTerminatedBy() != null) {
            this.print0(this.ucase ? " LINES" : " lines");
            if (x.getLinesStartingBy() != null) {
                this.print0(this.ucase ? " STARTING BY " : " starting by ");
                x.getLinesStartingBy().accept(this);
            }
            if (x.getLinesTerminatedBy() != null) {
                this.print0(this.ucase ? " TERMINATED BY " : " terminated by ");
                x.getLinesTerminatedBy().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlOutFileExpr x) {
    }

    @Override
    public boolean visit(MySqlDescribeStatement x) {
        this.print0(this.ucase ? "DESC " : "desc ");
        x.getObject().accept(this);
        if (x.getColName() != null) {
            this.print(' ');
            x.getColName().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlDescribeStatement x) {
    }

    @Override
    public boolean visit(MySqlUpdateStatement x) {
        if (x.getReturning() != null && x.getReturning().size() > 0) {
            this.print0(this.ucase ? "SELECT " : "select ");
            this.printAndAccept(x.getReturning(), ", ");
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
        }
        this.print0(this.ucase ? "UPDATE " : "update ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? "IGNORE " : "ignore ");
        }
        if (x.isCommitOnSuccess()) {
            this.print0(this.ucase ? "COMMIT_ON_SUCCESS " : "commit_on_success ");
        }
        if (x.isRollBackOnFail()) {
            this.print0(this.ucase ? "ROLLBACK_ON_FAIL " : "rollback_on_fail ");
        }
        if (x.isQueryOnPk()) {
            this.print0(this.ucase ? "QUEUE_ON_PK " : "queue_on_pk ");
        }
        if (x.getTargetAffectRow() != null) {
            this.print0(this.ucase ? "TARGET_AFFECT_ROW " : "target_affect_row ");
            x.getTargetAffectRow().accept(this);
            this.print(' ');
        }
        x.getTableSource().accept(this);
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.incrementIndent();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUpdateStatement x) {
    }

    @Override
    public boolean visit(MySqlSetTransactionStatement x) {
        if (x.getGlobal() == null) {
            this.print0(this.ucase ? "SET TRANSACTION " : "set transaction ");
        } else if (x.getGlobal().booleanValue()) {
            this.print0(this.ucase ? "SET GLOBAL TRANSACTION " : "set global transaction ");
        } else {
            this.print0(this.ucase ? "SET SESSION TRANSACTION " : "set session transaction ");
        }
        if (x.getIsolationLevel() != null) {
            this.print0(this.ucase ? "ISOLATION LEVEL " : "isolation level ");
            this.print0(x.getIsolationLevel());
        }
        if (x.getAccessModel() != null) {
            this.print0(this.ucase ? "READ " : "read ");
            this.print0(x.getAccessModel());
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSetTransactionStatement x) {
    }

    @Override
    public boolean visit(MySqlSetNamesStatement x) {
        this.print0(this.ucase ? "SET NAMES " : "set names ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT" : "default");
        } else {
            this.print0(x.getCharSet());
            if (x.getCollate() != null) {
                this.print0(this.ucase ? " COLLATE " : " collate ");
                this.print0(x.getCollate());
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSetNamesStatement x) {
    }

    @Override
    public boolean visit(MySqlSetCharSetStatement x) {
        this.print0(this.ucase ? "SET CHARACTER SET " : "set character set ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT" : "default");
        } else {
            this.print0(x.getCharSet());
            if (x.getCollate() != null) {
                this.print0(this.ucase ? " COLLATE " : " collate ");
                this.print0(x.getCollate());
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSetCharSetStatement x) {
    }

    @Override
    public void endVisit(MySqlShowAuthorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowAuthorsStatement x) {
        this.print0(this.ucase ? "SHOW AUTHORS" : "show authors");
        return false;
    }

    @Override
    public void endVisit(MySqlShowBinaryLogsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowBinaryLogsStatement x) {
        this.print0(this.ucase ? "SHOW BINARY LOGS" : "show binary logs");
        return false;
    }

    @Override
    public boolean visit(MySqlShowMasterLogsStatement x) {
        this.print0(this.ucase ? "SHOW MASTER LOGS" : "show master logs");
        return false;
    }

    @Override
    public void endVisit(MySqlShowMasterLogsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCollationStatement x) {
        this.print0(this.ucase ? "SHOW COLLATION" : "show collation");
        if (x.getPattern() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getPattern().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowCollationStatement x) {
    }

    @Override
    public boolean visit(MySqlShowBinLogEventsStatement x) {
        this.print0(this.ucase ? "SHOW BINLOG EVENTS" : "show binlog events");
        if (x.getIn() != null) {
            this.print0(this.ucase ? " IN " : " in ");
            x.getIn().accept(this);
        }
        if (x.getFrom() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getFrom().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(' ');
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowBinLogEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCharacterSetStatement x) {
        this.print0(this.ucase ? "SHOW CHARACTER SET" : "show character set");
        if (x.getPattern() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getPattern().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowCharacterSetStatement x) {
    }

    @Override
    public boolean visit(MySqlShowContributorsStatement x) {
        this.print0(this.ucase ? "SHOW CONTRIBUTORS" : "show contributors");
        return false;
    }

    @Override
    public void endVisit(MySqlShowContributorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateDatabaseStatement x) {
        this.print0(this.ucase ? "SHOW CREATE DATABASE " : "show create database ");
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateDatabaseStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateEventStatement x) {
        this.print0(this.ucase ? "SHOW CREATE EVENT " : "show create event ");
        x.getEventName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateEventStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateFunctionStatement x) {
        this.print0(this.ucase ? "SHOW CREATE FUNCTION " : "show create function ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateFunctionStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateProcedureStatement x) {
        this.print0(this.ucase ? "SHOW CREATE PROCEDURE " : "show create procedure ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateProcedureStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateTableStatement x) {
        this.print0(this.ucase ? "SHOW CREATE TABLE " : "show create table ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateTableStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateTriggerStatement x) {
        this.print0(this.ucase ? "SHOW CREATE TRIGGER " : "show create trigger ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateTriggerStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateViewStatement x) {
        this.print0(this.ucase ? "SHOW CREATE VIEW " : "show create view ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateViewStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEngineStatement x) {
        this.print0(this.ucase ? "SHOW ENGINE " : "show engine ");
        x.getName().accept(this);
        this.print(' ');
        this.print0(x.getOption().name());
        return false;
    }

    @Override
    public void endVisit(MySqlShowEngineStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEventsStatement x) {
        this.print0(this.ucase ? "SHOW EVENTS" : "show events");
        if (x.getSchema() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getSchema().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowFunctionCodeStatement x) {
        this.print0(this.ucase ? "SHOW FUNCTION CODE " : "show function code ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowFunctionCodeStatement x) {
    }

    @Override
    public boolean visit(MySqlShowFunctionStatusStatement x) {
        this.print0(this.ucase ? "SHOW FUNCTION STATUS" : "show function status");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowFunctionStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEnginesStatement x) {
        if (x.isStorage()) {
            this.print0(this.ucase ? "SHOW STORAGE ENGINES" : "show storage engines");
        } else {
            this.print0(this.ucase ? "SHOW ENGINES" : "show engines");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowEnginesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowErrorsStatement x) {
        if (x.isCount()) {
            this.print0(this.ucase ? "SHOW COUNT(*) ERRORS" : "show count(*) errors");
        } else {
            this.print0(this.ucase ? "SHOW ERRORS" : "show errors");
            if (x.getLimit() != null) {
                this.print(' ');
                x.getLimit().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowErrorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowGrantsStatement x) {
        this.print0(this.ucase ? "SHOW GRANTS" : "show grants");
        if (x.getUser() != null) {
            this.print0(this.ucase ? " FOR " : " for ");
            x.getUser().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowGrantsStatement x) {
    }

    @Override
    public boolean visit(MySqlUserName x) {
        this.print0(x.getUserName());
        if (x.getHost() != null) {
            this.print('@');
            this.print0(x.getHost());
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUserName x) {
    }

    @Override
    public boolean visit(MySqlShowIndexesStatement x) {
        this.print0(this.ucase ? "SHOW INDEX" : "show index");
        if (x.getTable() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowIndexesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowKeysStatement x) {
        this.print0(this.ucase ? "SHOW KEYS" : "show keys");
        if (x.getTable() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowKeysStatement x) {
    }

    @Override
    public boolean visit(MySqlShowMasterStatusStatement x) {
        this.print0(this.ucase ? "SHOW MASTER STATUS" : "show master status");
        return false;
    }

    @Override
    public void endVisit(MySqlShowMasterStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowOpenTablesStatement x) {
        this.print0(this.ucase ? "SHOW OPEN TABLES" : "show open tables");
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowOpenTablesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowPluginsStatement x) {
        this.print0(this.ucase ? "SHOW PLUGINS" : "show plugins");
        return false;
    }

    @Override
    public void endVisit(MySqlShowPluginsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowPrivilegesStatement x) {
        this.print0(this.ucase ? "SHOW PRIVILEGES" : "show privileges");
        return false;
    }

    @Override
    public void endVisit(MySqlShowPrivilegesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcedureCodeStatement x) {
        this.print0(this.ucase ? "SHOW PROCEDURE CODE " : "show procedure code ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcedureCodeStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcedureStatusStatement x) {
        this.print0(this.ucase ? "SHOW PROCEDURE STATUS" : "show procedure status");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcedureStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcessListStatement x) {
        if (x.isFull()) {
            this.print0(this.ucase ? "SHOW FULL PROCESSLIST" : "show full processlist");
        } else {
            this.print0(this.ucase ? "SHOW PROCESSLIST" : "show processlist");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcessListStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProfileStatement x) {
        this.print0(this.ucase ? "SHOW PROFILE" : "show profile");
        for (int i = 0; i < x.getTypes().size(); ++i) {
            if (i == 0) {
                this.print(' ');
            } else {
                this.print0(", ");
            }
            this.print0(x.getTypes().get((int)i).name);
        }
        if (x.getForQuery() != null) {
            this.print0(this.ucase ? " FOR QUERY " : " for query ");
            x.getForQuery().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(' ');
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProfileStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProfilesStatement x) {
        this.print0(this.ucase ? "SHOW PROFILES" : "show profiles");
        return false;
    }

    @Override
    public void endVisit(MySqlShowProfilesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowRelayLogEventsStatement x) {
        this.print0("SHOW RELAYLOG EVENTS");
        if (x.getLogName() != null) {
            this.print0(this.ucase ? " IN " : " in ");
            x.getLogName().accept(this);
        }
        if (x.getFrom() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getFrom().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(' ');
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowRelayLogEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowSlaveHostsStatement x) {
        this.print0(this.ucase ? "SHOW SLAVE HOSTS" : "show slave hosts");
        return false;
    }

    @Override
    public void endVisit(MySqlShowSlaveHostsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowSlaveStatusStatement x) {
        this.print0(this.ucase ? "SHOW SLAVE STATUS" : "show slave status");
        return false;
    }

    @Override
    public void endVisit(MySqlShowSlaveStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowTableStatusStatement x) {
        this.print0(this.ucase ? "SHOW TABLE STATUS" : "show table status");
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowTableStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowTriggersStatement x) {
        this.print0(this.ucase ? "SHOW TRIGGERS" : "show triggers");
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowTriggersStatement x) {
    }

    @Override
    public boolean visit(MySqlShowVariantsStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        if (x.isGlobal()) {
            this.print0(this.ucase ? "GLOBAL " : "global ");
        }
        if (x.isSession()) {
            this.print0(this.ucase ? "SESSION " : "session ");
        }
        this.print0(this.ucase ? "VARIABLES" : "variables");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowVariantsStatement x) {
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        if (x.isIgnore()) {
            this.print0(this.ucase ? "ALTER IGNORE TABLE " : "alter ignore table ");
        } else {
            this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
        }
        x.getName().accept(this);
        this.incrementIndent();
        for (int i = 0; i < x.getItems().size(); ++i) {
            SQLAlterTableItem item = x.getItems().get(i);
            if (i != 0) {
                this.print(',');
            }
            this.println();
            item.accept(this);
        }
        if (x.isRemovePatiting()) {
            this.println();
            this.print0(this.ucase ? "REMOVE PARTITIONING" : "remove partitioning");
        }
        if (x.isUpgradePatiting()) {
            this.println();
            this.print0(this.ucase ? "UPGRADE PARTITIONING" : "upgrade partitioning");
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD COLUMN " : "add column ");
        if (x.getColumns().size() > 1) {
            this.print('(');
        }
        this.printAndAccept(x.getColumns(), ", ");
        if (x.getFirstColumn() != null) {
            this.print0(this.ucase ? " FIRST " : " first ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print0(this.ucase ? " AFTER " : " after ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print0(this.ucase ? " FIRST" : " first");
        }
        if (x.getColumns().size() > 1) {
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(MySqlRenameTableStatement.Item x) {
        x.getName().accept(this);
        this.print0(this.ucase ? " TO " : " to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlRenameTableStatement.Item x) {
    }

    @Override
    public boolean visit(MySqlRenameTableStatement x) {
        this.print0(this.ucase ? "RENAME TABLE " : "rename table ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlRenameTableStatement x) {
    }

    @Override
    public boolean visit(MySqlUnionQuery x) {
        MySqlSelectQueryBlock right;
        boolean needParen = false;
        if (x.getLeft() instanceof MySqlSelectQueryBlock && ((right = (MySqlSelectQueryBlock)x.getLeft()).getOrderBy() != null || right.getLimit() != null)) {
            needParen = true;
        }
        if (needParen) {
            this.print('(');
            x.getLeft().accept(this);
            this.print(')');
        } else {
            x.getLeft().accept(this);
        }
        this.println();
        this.print0(this.ucase ? x.getOperator().name : x.getOperator().name_lcase);
        this.println();
        needParen = false;
        if (x.getOrderBy() != null || x.getLimit() != null) {
            needParen = true;
        } else if (x.getRight() instanceof MySqlSelectQueryBlock && ((right = (MySqlSelectQueryBlock)x.getRight()).getOrderBy() != null || right.getLimit() != null)) {
            needParen = true;
        }
        if (needParen) {
            this.print('(');
            x.getRight().accept(this);
            this.print(')');
        } else {
            x.getRight().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUnionQuery x) {
    }

    @Override
    public boolean visit(MySqlUseIndexHint x) {
        this.print0(this.ucase ? "USE INDEX " : "use index ");
        if (x.getOption() != null) {
            this.print0(this.ucase ? "FOR " : "for ");
            this.print0(x.getOption().name);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlUseIndexHint x) {
    }

    @Override
    public boolean visit(MySqlIgnoreIndexHint x) {
        this.print0(this.ucase ? "IGNORE INDEX " : "ignore index ");
        if (x.getOption() != null) {
            this.print0(this.ucase ? "FOR " : "for ");
            this.print0(this.ucase ? x.getOption().name : x.getOption().name_lcase);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlIgnoreIndexHint x) {
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        for (int i = 0; i < x.getHintsSize(); ++i) {
            this.print(' ');
            x.getHints().get(i).accept(this);
        }
        if (x.getPartitionSize() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printlnAndAccept(x.getPartitions(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(MySqlLockTableStatement x) {
        this.print0(this.ucase ? "LOCK TABLES " : "lock tables ");
        x.getTableSource().accept(this);
        if (x.getLockType() != null) {
            this.print(' ');
            this.print0(x.getLockType().name);
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlLockTableStatement x) {
    }

    @Override
    public boolean visit(MySqlUnlockTablesStatement x) {
        this.print0(this.ucase ? "UNLOCK TABLES" : "unlock tables");
        return false;
    }

    @Override
    public void endVisit(MySqlUnlockTablesStatement x) {
    }

    @Override
    public boolean visit(MySqlForceIndexHint x) {
        this.print0(this.ucase ? "FORCE INDEX " : "force index ");
        if (x.getOption() != null) {
            this.print0(this.ucase ? "FOR " : "for ");
            this.print0(x.getOption().name);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlForceIndexHint x) {
    }

    @Override
    public boolean visit(MySqlAlterTableChangeColumn x) {
        this.print0(this.ucase ? "CHANGE COLUMN " : "change column ");
        x.getColumnName().accept(this);
        this.print(' ');
        x.getNewColumnDefinition().accept(this);
        if (x.getFirstColumn() != null) {
            this.print0(this.ucase ? " FIRST " : " first ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print0(this.ucase ? " AFTER " : " after ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print0(this.ucase ? " FIRST" : " first");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableChangeColumn x) {
    }

    @Override
    public boolean visit(MySqlAlterTableModifyColumn x) {
        this.print0(this.ucase ? "MODIFY COLUMN " : "modify column ");
        x.getNewColumnDefinition().accept(this);
        if (x.getFirstColumn() != null) {
            this.print0(this.ucase ? " FIRST " : " first ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print0(this.ucase ? " AFTER " : " after ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print0(this.ucase ? " FIRST" : " first");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableModifyColumn x) {
    }

    @Override
    public boolean visit(MySqlAlterTableCharacter x) {
        this.print0(this.ucase ? "CHARACTER SET = " : "character set = ");
        x.getCharacterSet().accept(this);
        if (x.getCollate() != null) {
            this.print0(this.ucase ? ", COLLATE = " : ", collate = ");
            x.getCollate().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableCharacter x) {
    }

    @Override
    public boolean visit(MySqlAlterTableOption x) {
        this.print0(x.getName());
        this.print0(" = ");
        this.print0(x.getValue().toString());
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableOption x) {
    }

    @Override
    public void endVisit(MySqlCreateTableStatement x) {
    }

    @Override
    public boolean visit(MySqlHelpStatement x) {
        this.print0(this.ucase ? "HELP " : "help ");
        x.getContent().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlHelpStatement x) {
    }

    @Override
    public boolean visit(MySqlCharExpr x) {
        this.print0(x.toString());
        return false;
    }

    @Override
    public void endVisit(MySqlCharExpr x) {
    }

    @Override
    public boolean visit(MySqlUnique x) {
        if (x.isHasConstaint()) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print0(this.ucase ? "UNIQUE" : "unique");
        if (x.getIndexName() != null) {
            this.print(' ');
            x.getIndexName().accept(this);
        }
        if (x.getIndexType() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getIndexType());
        }
        this.print0(" (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(MysqlForeignKey x) {
        if (x.isHasConstraint()) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print0(this.ucase ? "FOREIGN KEY" : "foreign key");
        if (x.getIndexName() != null) {
            this.print(' ');
            x.getIndexName().accept(this);
        }
        this.print0(" (");
        this.printAndAccept(x.getReferencingColumns(), ", ");
        this.print(')');
        this.print0(this.ucase ? " REFERENCES " : " references ");
        x.getReferencedTableName().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getReferencedColumns(), ", ");
        this.print(')');
        MysqlForeignKey.Match match = x.getReferenceMatch();
        if (match != null) {
            this.print0(this.ucase ? " MATCH " : " match ");
            this.print0(this.ucase ? match.name : match.name_lcase);
        }
        if (x.getOnDelete() != null) {
            this.print0(this.ucase ? " ON DELETE " : " on delete ");
            this.print0(this.ucase ? x.getOnDelete().name : x.getOnDelete().name_lcase);
        }
        if (x.getOnDelete() != null) {
            this.print0(this.ucase ? " ON UPDATE " : " on update ");
            this.print0(this.ucase ? x.getOnDelete().name : x.getOnDelete().name_lcase);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUnique x) {
    }

    @Override
    public boolean visit(MySqlAlterTableDiscardTablespace x) {
        this.print0(this.ucase ? "DISCARD TABLESPACE" : "discard tablespace");
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableDiscardTablespace x) {
    }

    @Override
    public boolean visit(MySqlAlterTableImportTablespace x) {
        this.print0(this.ucase ? "IMPORT TABLESPACE" : "import tablespace");
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableImportTablespace x) {
    }

    @Override
    public boolean visit(SQLAssignItem x) {
        x.getTarget().accept(this);
        if (!"NAMES".equalsIgnoreCase(x.getTarget().toString())) {
            this.print0(" = ");
        }
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(MySqlCreateTableStatement.TableSpaceOption x) {
        x.getName().accept(this);
        if (x.getStorage() != null) {
            this.print(' ');
            x.getStorage().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateTableStatement.TableSpaceOption x) {
    }

    @Override
    protected void visitAggreateRest(SQLAggregateExpr aggregateExpr) {
        Object value = (SQLOrderBy)aggregateExpr.getAttribute("ORDER BY");
        if (value != null) {
            this.print(' ');
            value.accept(this);
        }
        if ((value = aggregateExpr.getAttribute("SEPARATOR")) != null) {
            this.print0(this.ucase ? " SEPARATOR " : " separator ");
            ((SQLObject)value).accept(this);
        }
    }

    @Override
    public boolean visit(MySqlAnalyzeStatement x) {
        this.print0(this.ucase ? "ANALYZE " : "analyze ");
        if (x.isNoWriteToBinlog()) {
            this.print0(this.ucase ? "NO_WRITE_TO_BINLOG " : "no_write_to_binlog ");
        }
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        this.printAndAccept(x.getTableSources(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlAnalyzeStatement x) {
    }

    @Override
    public boolean visit(MySqlOptimizeStatement x) {
        this.print0(this.ucase ? "OPTIMIZE " : "optimize ");
        if (x.isNoWriteToBinlog()) {
            this.print0(this.ucase ? "NO_WRITE_TO_BINLOG " : "No_write_to_binlog ");
        }
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        this.printAndAccept(x.getTableSources(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlOptimizeStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterUserStatement x) {
        this.print0(this.ucase ? "ALTER USER" : "alter user");
        for (SQLExpr user : x.getUsers()) {
            this.print(' ');
            user.accept(this);
            this.print0(this.ucase ? " PASSWORD EXPIRE" : " password expire");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterUserStatement x) {
    }

    @Override
    public boolean visit(MySqlSetPasswordStatement x) {
        this.print0(this.ucase ? "SET PASSWORD " : "set password ");
        if (x.getUser() != null) {
            this.print0(this.ucase ? "FOR " : "for ");
            x.getUser().accept(this);
            this.print(' ');
        }
        this.print0("= ");
        if (x.getPassword() != null) {
            x.getPassword().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSetPasswordStatement x) {
    }

    @Override
    public boolean visit(MySqlHintStatement x) {
        List<SQLCommentHint> hints = x.getHints();
        for (SQLCommentHint hint : hints) {
            hint.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlHintStatement x) {
    }

    @Override
    public boolean visit(MySqlOrderingExpr x) {
        x.getExpr().accept(this);
        if (x.getType() != null) {
            this.print(' ');
            this.print0(this.ucase ? x.getType().name : x.getType().name_lcase);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlOrderingExpr x) {
    }

    @Override
    public boolean visit(SQLBlockStatement x) {
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(x.getLabelName());
            this.print0(": ");
        }
        this.print0(this.ucase ? "BEGIN" : "begin");
        this.incrementIndent();
        this.println();
        int size = x.getStatementList().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement stmt = x.getStatementList().get(i);
            stmt.setParent(x);
            stmt.accept(this);
            this.print(';');
        }
        this.decrementIndent();
        this.println();
        this.print0(this.ucase ? "END" : "end");
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print(' ');
            this.print0(x.getLabelName());
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateProcedureStatement x) {
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "CREATE OR REPLACE PROCEDURE " : "create or replace procedure ");
        } else {
            this.print0(this.ucase ? "CREATE PROCEDURE " : "create procedure ");
        }
        x.getName().accept(this);
        int paramSize = x.getParameters().size();
        this.print0(" (");
        if (paramSize > 0) {
            this.incrementIndent();
            this.println();
            for (int i = 0; i < paramSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                SQLParameter param = x.getParameters().get(i);
                param.accept(this);
            }
            this.decrementIndent();
            this.println();
        }
        this.print(')');
        this.println();
        x.getBlock().setParent(x);
        x.getBlock().accept(this);
        return false;
    }

    @Override
    public boolean visit(MySqlWhileStatement x) {
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(x.getLabelName());
            this.print0(": ");
        }
        this.print0(this.ucase ? "WHILE " : "while ");
        x.getCondition().accept(this);
        this.print0(this.ucase ? " DO" : " do");
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.println();
        this.print0(this.ucase ? "END WHILE" : "end while");
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print(' ');
        }
        this.print0(x.getLabelName());
        return false;
    }

    @Override
    public void endVisit(MySqlWhileStatement x) {
    }

    @Override
    public boolean visit(SQLIfStatement x) {
        this.print0(this.ucase ? "IF " : "if ");
        x.getCondition().accept(this);
        this.print0(this.ucase ? " THEN" : " then");
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.println();
        for (SQLIfStatement.ElseIf iterable_element : x.getElseIfList()) {
            iterable_element.accept(this);
        }
        if (x.getElseItem() != null) {
            x.getElseItem().accept(this);
        }
        this.print0(this.ucase ? "END IF" : "end if");
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement.ElseIf x) {
        this.print0(this.ucase ? "ELSE IF " : "else if ");
        x.getCondition().accept(this);
        this.print0(this.ucase ? " THEN" : " then");
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.println();
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement.Else x) {
        this.print0(this.ucase ? "ELSE " : "else ");
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.println();
        return false;
    }

    @Override
    public boolean visit(MySqlCaseStatement x) {
        this.print0(this.ucase ? "CASE " : "case ");
        x.getCondition().accept(this);
        this.println();
        for (int i = 0; i < x.getWhenList().size(); ++i) {
            x.getWhenList().get(i).accept(this);
        }
        if (x.getElseItem() != null) {
            x.getElseItem().accept(this);
        }
        this.print0(this.ucase ? "END CASE" : "end case");
        return false;
    }

    @Override
    public void endVisit(MySqlCaseStatement x) {
    }

    @Override
    public boolean visit(MySqlDeclareStatement x) {
        this.print0(this.ucase ? "DECLARE " : "declare ");
        this.printAndAccept(x.getVarList(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlDeclareStatement x) {
    }

    @Override
    public boolean visit(MySqlSelectIntoStatement x) {
        x.getSelect().accept(this);
        this.print0(this.ucase ? " INTO " : " into ");
        for (int i = 0; i < x.getVarList().size(); ++i) {
            x.getVarList().get(i).accept(this);
            if (i == x.getVarList().size() - 1) continue;
            this.print0(", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSelectIntoStatement x) {
    }

    @Override
    public boolean visit(MySqlCaseStatement.MySqlWhenStatement x) {
        this.print0(this.ucase ? "WHEN " : "when ");
        x.getCondition().accept(this);
        this.print0(" THEN");
        this.println();
        for (int i = 0; i < x.getStatements().size(); ++i) {
            x.getStatements().get(i).accept(this);
            if (i == x.getStatements().size() - 1) continue;
            this.println();
        }
        this.println();
        return false;
    }

    @Override
    public void endVisit(MySqlCaseStatement.MySqlWhenStatement x) {
    }

    @Override
    public boolean visit(SQLLoopStatement x) {
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(x.getLabelName());
            this.print0(": ");
        }
        this.print0(this.ucase ? "LOOP " : "loop ");
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.println();
        this.print0(this.ucase ? "END LOOP" : "end loop");
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(" ");
            this.print0(x.getLabelName());
        }
        return false;
    }

    @Override
    public boolean visit(MySqlLeaveStatement x) {
        this.print0(this.ucase ? "LEAVE " : "leave ");
        this.print0(x.getLabelName());
        return false;
    }

    @Override
    public void endVisit(MySqlLeaveStatement x) {
    }

    @Override
    public boolean visit(MySqlIterateStatement x) {
        this.print0(this.ucase ? "ITERATE " : "iterate ");
        this.print0(x.getLabelName());
        return false;
    }

    @Override
    public void endVisit(MySqlIterateStatement x) {
    }

    @Override
    public boolean visit(MySqlRepeatStatement x) {
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(x.getLabelName());
            this.print0(": ");
        }
        this.print0(this.ucase ? "REPEAT " : "repeat ");
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.println();
        this.print0(this.ucase ? "UNTIL " : "until ");
        x.getCondition().accept(this);
        this.println();
        this.print0(this.ucase ? "END REPEAT" : "end repeat");
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print(' ');
            this.print0(x.getLabelName());
        }
        return false;
    }

    @Override
    public void endVisit(MySqlRepeatStatement x) {
    }

    @Override
    public boolean visit(MySqlCursorDeclareStatement x) {
        this.print0(this.ucase ? "DECLARE " : "declare ");
        this.print0(x.getCursorName());
        this.print0(this.ucase ? " CURSOR FOR " : " cursor for ");
        x.getSelect().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlCursorDeclareStatement x) {
    }

    @Override
    public boolean visit(MySqlUpdateTableSource x) {
        MySqlUpdateStatement update = x.getUpdate();
        if (update != null) {
            update.accept0(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUpdateTableSource x) {
    }

    @Override
    public boolean visit(MySqlAlterTableAlterColumn x) {
        this.print0(this.ucase ? "ALTER COLUMN " : "alter column ");
        x.getColumn().accept(this);
        if (x.getDefaultExpr() != null) {
            this.print0(this.ucase ? " SET DEFAULT " : " set default ");
            x.getDefaultExpr().accept(this);
        } else if (x.isDropDefault()) {
            this.print0(this.ucase ? " DROP DEFAULT" : " drop default");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableAlterColumn x) {
    }

    @Override
    public boolean visit(MySqlSubPartitionByKey x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "SUBPARTITION BY LINEAR KEY (" : "subpartition by linear key (");
        } else {
            this.print0(this.ucase ? "SUBPARTITION BY KEY (" : "subpartition by key (");
        }
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        if (x.getSubPartitionsCount() != null) {
            this.print0(this.ucase ? " SUBPARTITIONS " : " subpartitions ");
            x.getSubPartitionsCount().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSubPartitionByKey x) {
    }

    @Override
    public boolean visit(MySqlSubPartitionByList x) {
        this.print0(this.ucase ? "SUBPARTITION BY LIST " : "subpartition by list ");
        if (x.getExpr() != null) {
            this.print('(');
            x.getExpr().accept(this);
            this.print0(") ");
        } else {
            if (x.getColumns().size() == 1 && Boolean.TRUE.equals(x.getAttribute("ads.subPartitionList"))) {
                this.print('(');
            } else {
                this.print0(this.ucase ? "COLUMNS (" : "columns (");
            }
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        if (x.getOptions().size() != 0) {
            this.println();
            this.print0(this.ucase ? "SUBPARTITION OPTIONS (" : "subpartition options (");
            this.printAndAccept(x.getOptions(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSubPartitionByList x) {
    }

    @Override
    public boolean visit(MySqlDeclareHandlerStatement x) {
        this.print0(this.ucase ? "DECLARE " : "declare ");
        this.print0(this.ucase ? x.getHandleType().toString().toUpperCase() : x.getHandleType().toString().toLowerCase());
        this.print0(this.ucase ? " HANDLER FOR " : " handler for ");
        for (int i = 0; i < x.getConditionValues().size(); ++i) {
            ConditionValue cv = x.getConditionValues().get(i);
            if (cv.getType() == ConditionValue.ConditionType.SQLSTATE) {
                this.print0(this.ucase ? " SQLSTATE " : " sqlstate ");
                this.print0(cv.getValue());
            } else if (cv.getType() == ConditionValue.ConditionType.MYSQL_ERROR_CODE) {
                this.print0(cv.getValue());
            } else if (cv.getType() == ConditionValue.ConditionType.SELF) {
                this.print0(cv.getValue());
            } else if (cv.getType() == ConditionValue.ConditionType.SYSTEM) {
                this.print0(this.ucase ? cv.getValue().toUpperCase() : cv.getValue().toLowerCase());
            }
            if (i == x.getConditionValues().size() - 1) continue;
            this.print0(", ");
        }
        this.println();
        return true;
    }

    @Override
    public void endVisit(MySqlDeclareHandlerStatement x) {
    }

    @Override
    public boolean visit(MySqlDeclareConditionStatement x) {
        this.print0(this.ucase ? "DECLARE " : "declare ");
        this.print0(x.getConditionName());
        this.print0(this.ucase ? " CONDITION FOR " : " condition for ");
        if (x.getConditionValue().getType() == ConditionValue.ConditionType.SQLSTATE) {
            this.print0(this.ucase ? "SQLSTATE " : "sqlstate ");
            this.print0(x.getConditionValue().getValue());
        } else {
            this.print0(x.getConditionValue().getValue());
        }
        this.println();
        return false;
    }

    @Override
    public void endVisit(MySqlDeclareConditionStatement x) {
    }
}

