/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.teradata.visitor;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataAnalytic;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataAnalyticWindowing;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataIntervalExpr;
import com.alibaba.druid.sql.dialect.teradata.visitor.TeradataASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class TeradataSchemaStatVisitor
extends SchemaStatVisitor
implements TeradataASTVisitor {
    protected final Map<String, SQLObject> aliasQueryMap = new LinkedHashMap<String, SQLObject>();

    @Override
    public String getDbType() {
        return "teradata";
    }

    @Override
    public boolean visit(TeradataAnalyticWindowing x) {
        return true;
    }

    @Override
    public void endVisit(TeradataAnalyticWindowing x) {
    }

    @Override
    public boolean visit(TeradataAnalytic x) {
        return false;
    }

    @Override
    public boolean visit(TeradataIntervalExpr x) {
        return true;
    }

    @Override
    public void endVisit(TeradataIntervalExpr x) {
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.accept(x.getSelect());
        String table = (String)x.getSelect().getAttribute("_table_");
        if (this.aliasMap != null && x.getAlias() != null) {
            if (table != null) {
                this.aliasMap.put(x.getAlias(), table);
            }
            this.addSubQuery(x.getAlias(), x.getSelect());
            this.setCurrentTable(x.getAlias());
        }
        if (table != null) {
            x.putAttribute("_table_", table);
        }
        return false;
    }

    @Override
    public void endVisit(SQLSubqueryTableSource x) {
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        x.getExpr().accept(this);
        String alias = x.getAlias();
        Map<String, String> aliasMap = this.getAliasMap();
        if (alias != null && !alias.isEmpty() && aliasMap != null) {
            if (x.getExpr() instanceof SQLName) {
                TeradataSchemaStatVisitor.putAliasMap(aliasMap, alias, x.getExpr().toString());
            } else {
                TeradataSchemaStatVisitor visitor = new TeradataSchemaStatVisitor();
                x.getExpr().accept(visitor);
                TeradataSchemaStatVisitor.putAliasMap(aliasMap, alias, null);
                String uniqueAliasName = this.getCurrentTable() == null ? alias : this.getCurrentTable() + "." + alias;
                this.addAliasQuery(uniqueAliasName, x.getExpr());
            }
        }
        return false;
    }

    protected void addAliasQuery(String alias, SQLObject query) {
        String alias_lcase = alias.toLowerCase();
        this.aliasQueryMap.put(alias_lcase, query);
    }

    public SQLObject getAliasQuery(String alias) {
        String alias_lcase = alias.toLowerCase();
        return this.aliasQueryMap.get(alias_lcase);
    }

    public Map<String, SQLObject> getAliasQueryMap() {
        return this.aliasQueryMap;
    }
}

