/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.h2.util.Utils;

public class StringUtils {
    private static SoftReference<String[]> softCache;
    private static long softCacheCreatedNs;
    private static final char[] HEX;
    private static final int[] HEX_DECODE;
    private static final int TO_UPPER_CACHE_LENGTH = 2048;
    private static final int TO_UPPER_CACHE_MAX_ENTRY_LENGTH = 64;
    private static final String[][] TO_UPPER_CACHE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCache() {
        String[] arrayOfString1;
        if (softCache != null && (arrayOfString1 = softCache.get()) != null) {
            return arrayOfString1;
        }
        long l = System.nanoTime();
        if (softCacheCreatedNs != 0L && l - softCacheCreatedNs < TimeUnit.SECONDS.toNanos(5L)) {
            return null;
        }
        try {
            arrayOfString1 = new String[1024];
            softCache = new SoftReference<String[]>(arrayOfString1);
            String[] stringArray = arrayOfString1;
            return stringArray;
        }
        finally {
            softCacheCreatedNs = System.nanoTime();
        }
    }

    public static String toUpperEnglish(String paramString) {
        if (paramString.length() > 64) {
            return paramString.toUpperCase(Locale.ENGLISH);
        }
        int i = paramString.hashCode() & 0x7FF;
        String[] arrayOfString = TO_UPPER_CACHE[i];
        if (arrayOfString != null && arrayOfString[0].equals(paramString)) {
            return arrayOfString[1];
        }
        String str = paramString.toUpperCase(Locale.ENGLISH);
        arrayOfString = new String[]{paramString, str};
        StringUtils.TO_UPPER_CACHE[i] = arrayOfString;
        return str;
    }

    public static String toLowerEnglish(String paramString) {
        return paramString.toLowerCase(Locale.ENGLISH);
    }

    public static String quoteStringSQL(String paramString) {
        if (paramString == null) {
            return "NULL";
        }
        return StringUtils.quoteStringSQL(new StringBuilder(paramString.length() + 2), paramString).toString();
    }

    public static StringBuilder quoteStringSQL(StringBuilder paramStringBuilder, String paramString) {
        if (paramString == null) {
            return paramStringBuilder.append("NULL");
        }
        return StringUtils.quoteIdentifierOrLiteral(paramStringBuilder, paramString, '\'');
    }

    public static String decodeUnicodeStringSQL(String paramString, int paramInt) {
        int i = paramString.length();
        StringBuilder localStringBuilder = new StringBuilder(i);
        int j = 0;
        while (j < i) {
            int k = paramString.codePointAt(j);
            j += Character.charCount(k);
            if (k == paramInt) {
                if (j >= i) {
                    throw StringUtils.getFormatException(paramString, j);
                }
                k = paramString.codePointAt(j);
                if (k == paramInt) {
                    j += Character.charCount(k);
                } else {
                    if (j + 4 > i) {
                        throw StringUtils.getFormatException(paramString, j);
                    }
                    char m = paramString.charAt(j);
                    try {
                        if (m == '+') {
                            if (j + 7 > i) {
                                throw StringUtils.getFormatException(paramString, j);
                            }
                            k = Integer.parseUnsignedInt(paramString.substring((j += 7) + 1, j), 16);
                        } else {
                            k = Integer.parseUnsignedInt(paramString.substring(j + 1, j), 16);
                        }
                    }
                    catch (NumberFormatException localNumberFormatException) {
                        throw StringUtils.getFormatException(paramString, j);
                    }
                }
            }
            localStringBuilder.appendCodePoint(k);
        }
        return localStringBuilder.toString();
    }

    public static String javaEncode(String paramString) {
        StringBuilder localStringBuilder = new StringBuilder(paramString.length());
        StringUtils.javaEncode(paramString, localStringBuilder, false);
        return localStringBuilder.toString();
    }

    public static void javaEncode(String paramString, StringBuilder paramStringBuilder, boolean paramBoolean) {
        int i = paramString.length();
        block9: for (int j = 0; j < i; ++j) {
            char c = paramString.charAt(j);
            switch (c) {
                case '\t': {
                    paramStringBuilder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    paramStringBuilder.append("\\n");
                    continue block9;
                }
                case '\f': {
                    paramStringBuilder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    paramStringBuilder.append("\\r");
                    continue block9;
                }
                case '\"': {
                    paramStringBuilder.append("\\\"");
                    continue block9;
                }
                case '\'': {
                    if (paramBoolean) {
                        paramStringBuilder.append('\'');
                    }
                    paramStringBuilder.append('\'');
                    continue block9;
                }
                case '\\': {
                    paramStringBuilder.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && c < '\u0080') {
                        paramStringBuilder.append(c);
                        continue block9;
                    }
                    paramStringBuilder.append("\\u").append(HEX[c >>> 12]).append(HEX[c >>> 8 & 0xF]).append(HEX[c >>> 4 & 0xF]).append(HEX[c & 0xF]);
                }
            }
        }
    }

    public static String addAsterisk(String paramString, int paramInt) {
        if (paramString != null) {
            int i = paramString.length();
            paramInt = Math.min(paramInt, i);
            paramString = new StringBuilder(i + 3).append(paramString, 0, paramInt).append("[*]").append(paramString, paramInt, i).toString();
        }
        return paramString;
    }

    private static RuntimeException getFormatException(String paramString, int paramInt) {
        return new RuntimeException(StringUtils.addAsterisk(paramString, paramInt));
    }

    public static String javaDecode(String paramString) {
        int i = paramString.length();
        StringBuilder localStringBuilder = new StringBuilder(i);
        block17: for (int j = 0; j < i; ++j) {
            char c = paramString.charAt(j);
            if (c == '\\') {
                if (j + 1 >= paramString.length()) {
                    throw StringUtils.getFormatException(paramString, j);
                }
                c = paramString.charAt(++j);
                switch (c) {
                    case 't': {
                        localStringBuilder.append('\t');
                        continue block17;
                    }
                    case 'r': {
                        localStringBuilder.append('\r');
                        continue block17;
                    }
                    case 'n': {
                        localStringBuilder.append('\n');
                        continue block17;
                    }
                    case 'b': {
                        localStringBuilder.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        localStringBuilder.append('\f');
                        continue block17;
                    }
                    case '#': {
                        localStringBuilder.append('#');
                        continue block17;
                    }
                    case '=': {
                        localStringBuilder.append('=');
                        continue block17;
                    }
                    case ':': {
                        localStringBuilder.append(':');
                        continue block17;
                    }
                    case '\"': {
                        localStringBuilder.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        localStringBuilder.append('\\');
                        continue block17;
                    }
                    case 'u': {
                        if (j + 4 >= i) {
                            throw StringUtils.getFormatException(paramString, j);
                        }
                        try {
                            c = (char)Integer.parseInt(paramString.substring(j + 1, j + 5), 16);
                        }
                        catch (NumberFormatException localNumberFormatException1) {
                            throw StringUtils.getFormatException(paramString, j);
                        }
                        j += 4;
                        localStringBuilder.append(c);
                        continue block17;
                    }
                    default: {
                        if (c >= '0' && c <= '9' && j + 2 < i) {
                            try {
                                c = (char)Integer.parseInt(paramString.substring(j, j + 3), 8);
                            }
                            catch (NumberFormatException localNumberFormatException2) {
                                throw StringUtils.getFormatException(paramString, j);
                            }
                            j += 2;
                            localStringBuilder.append(c);
                            continue block17;
                        }
                        throw StringUtils.getFormatException(paramString, j);
                    }
                }
            }
            localStringBuilder.append(c);
        }
        return localStringBuilder.toString();
    }

    public static String quoteJavaString(String paramString) {
        if (paramString == null) {
            return "null";
        }
        StringBuilder localStringBuilder = new StringBuilder(paramString.length() + 2).append('\"');
        StringUtils.javaEncode(paramString, localStringBuilder, false);
        return localStringBuilder.append('\"').toString();
    }

    public static String quoteJavaStringArray(String[] paramArrayOfString) {
        if (paramArrayOfString == null) {
            return "null";
        }
        StringBuilder localStringBuilder = new StringBuilder("new String[]{");
        for (int i = 0; i < paramArrayOfString.length; ++i) {
            if (i > 0) {
                localStringBuilder.append(", ");
            }
            localStringBuilder.append(StringUtils.quoteJavaString(paramArrayOfString[i]));
        }
        return localStringBuilder.append('}').toString();
    }

    public static String quoteJavaIntArray(int[] paramArrayOfInt) {
        if (paramArrayOfInt == null) {
            return "null";
        }
        StringBuilder localStringBuilder = new StringBuilder("new int[]{");
        for (int i = 0; i < paramArrayOfInt.length; ++i) {
            if (i > 0) {
                localStringBuilder.append(", ");
            }
            localStringBuilder.append(paramArrayOfInt[i]);
        }
        return localStringBuilder.append('}').toString();
    }

    public static String urlEncode(String paramString) {
        try {
            return URLEncoder.encode(paramString, "UTF-8");
        }
        catch (Exception localException) {
            throw new RuntimeException(localException);
        }
    }

    public static String urlDecode(String paramString) {
        int i = paramString.length();
        byte[] arrayOfByte = new byte[i];
        int j = 0;
        for (int k = 0; k < i; ++k) {
            char m = paramString.charAt(k);
            if (m == '+') {
                arrayOfByte[j++] = 32;
                continue;
            }
            if (m == '%') {
                arrayOfByte[j++] = (byte)Integer.parseInt(paramString.substring(k + 1, k + 3), 16);
                k += 2;
                continue;
            }
            if (m <= '\u007f' && m >= ' ') {
                arrayOfByte[j++] = (byte)m;
                continue;
            }
            throw new IllegalArgumentException("Unexpected char " + m + " decoding " + paramString);
        }
        return new String(arrayOfByte, 0, j, StandardCharsets.UTF_8);
    }

    public static String[] arraySplit(String paramString, char paramChar, boolean paramBoolean) {
        if (paramString == null) {
            return null;
        }
        int i = paramString.length();
        if (i == 0) {
            return new String[0];
        }
        ArrayList localArrayList = Utils.newSmallArrayList();
        StringBuilder localStringBuilder = new StringBuilder(i);
        for (int j = 0; j < i; ++j) {
            char c = paramString.charAt(j);
            if (c == paramChar) {
                String str2 = localStringBuilder.toString();
                localArrayList.add(paramBoolean ? str2.trim() : str2);
                localStringBuilder.setLength(0);
                continue;
            }
            if (c == '\\' && j < i - 1) {
                localStringBuilder.append(paramString.charAt(++j));
                continue;
            }
            localStringBuilder.append(c);
        }
        String str1 = localStringBuilder.toString();
        localArrayList.add(paramBoolean ? str1.trim() : str1);
        return localArrayList.toArray(new String[0]);
    }

    public static String arrayCombine(String[] paramArrayOfString, char paramChar) {
        StringBuilder localStringBuilder = new StringBuilder();
        for (int i = 0; i < paramArrayOfString.length; ++i) {
            String str;
            if (i > 0) {
                localStringBuilder.append(paramChar);
            }
            if ((str = paramArrayOfString[i]) == null) continue;
            int k = str.length();
            for (int j = 0; j < k; ++j) {
                char c = str.charAt(j);
                if (c == '\\' || c == paramChar) {
                    localStringBuilder.append('\\');
                }
                localStringBuilder.append(c);
            }
        }
        return localStringBuilder.toString();
    }

    public static String xmlAttr(String paramString1, String paramString2) {
        return " " + paramString1 + "=\"" + StringUtils.xmlText(paramString2) + "\"";
    }

    public static String xmlNode(String paramString1, String paramString2, String paramString3) {
        return StringUtils.xmlNode(paramString1, paramString2, paramString3, true);
    }

    public static String xmlNode(String paramString1, String paramString2, String paramString3, boolean paramBoolean) {
        StringBuilder localStringBuilder = new StringBuilder();
        localStringBuilder.append('<').append(paramString1);
        if (paramString2 != null) {
            localStringBuilder.append(paramString2);
        }
        if (paramString3 == null) {
            localStringBuilder.append("/>\n");
            return localStringBuilder.toString();
        }
        localStringBuilder.append('>');
        if (paramBoolean && paramString3.indexOf(10) >= 0) {
            localStringBuilder.append('\n');
            StringUtils.indent(localStringBuilder, paramString3, 4, true);
        } else {
            localStringBuilder.append(paramString3);
        }
        localStringBuilder.append("</").append(paramString1).append(">\n");
        return localStringBuilder.toString();
    }

    public static StringBuilder indent(StringBuilder paramStringBuilder, String paramString, int paramInt, boolean paramBoolean) {
        int i = 0;
        int j = paramString.length();
        while (i < j) {
            int k = 0;
            while (k < paramInt) {
                paramStringBuilder.append(' ');
                k = paramString.indexOf(10, i);
                k = k < 0 ? j : k + 1;
                paramStringBuilder.append(paramString, i, k);
                i = k++;
            }
        }
        if (paramBoolean && !paramString.endsWith("\n")) {
            paramStringBuilder.append('\n');
        }
        return paramStringBuilder;
    }

    public static String xmlComment(String paramString) {
        int i = 0;
        while ((i = paramString.indexOf("--", i)) >= 0) {
            paramString = paramString.substring(0, i + 1) + " " + paramString.substring(i + 1);
        }
        if (paramString.indexOf(10) >= 0) {
            StringBuilder localStringBuilder = new StringBuilder(paramString.length() + 18).append("<!--\n");
            return StringUtils.indent(localStringBuilder, paramString, 4, true).append("-->\n").toString();
        }
        return "<!-- " + paramString + " -->\n";
    }

    public static String xmlCData(String paramString) {
        if (paramString.contains("]]>")) {
            return StringUtils.xmlText(paramString);
        }
        boolean bool = paramString.endsWith("\n");
        paramString = "<![CDATA[" + paramString + "]]>";
        return bool ? paramString + "\n" : paramString;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String paramString) {
        return StringUtils.xmlText(paramString, false);
    }

    public static String xmlText(String paramString, boolean paramBoolean) {
        int i = paramString.length();
        StringBuilder localStringBuilder = new StringBuilder(i);
        block9: for (int j = 0; j < i; ++j) {
            char c = paramString.charAt(j);
            switch (c) {
                case '<': {
                    localStringBuilder.append("&lt;");
                    continue block9;
                }
                case '>': {
                    localStringBuilder.append("&gt;");
                    continue block9;
                }
                case '&': {
                    localStringBuilder.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    localStringBuilder.append("&#39;");
                    continue block9;
                }
                case '\"': {
                    localStringBuilder.append("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (paramBoolean) {
                        localStringBuilder.append("&#x").append(Integer.toHexString(c)).append(';');
                        continue block9;
                    }
                    localStringBuilder.append(c);
                    continue block9;
                }
                case '\t': {
                    localStringBuilder.append(c);
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        localStringBuilder.append("&#x").append(Integer.toHexString(c)).append(';');
                        continue block9;
                    }
                    localStringBuilder.append(c);
                }
            }
        }
        return localStringBuilder.toString();
    }

    public static String replaceAll(String paramString1, String paramString2, String paramString3) {
        int i = paramString1.indexOf(paramString2);
        if (i < 0 || paramString2.isEmpty()) {
            return paramString1;
        }
        StringBuilder localStringBuilder = new StringBuilder(paramString1.length() - paramString2.length() + paramString3.length());
        int j = 0;
        do {
            localStringBuilder.append(paramString1, j, i).append(paramString3);
        } while ((i = paramString1.indexOf(paramString2, j = i + paramString2.length())) >= 0);
        localStringBuilder.append(paramString1, j, paramString1.length());
        return localStringBuilder.toString();
    }

    public static String quoteIdentifier(String paramString) {
        return StringUtils.quoteIdentifierOrLiteral(new StringBuilder(paramString.length() + 2), paramString, '\"').toString();
    }

    public static StringBuilder quoteIdentifier(StringBuilder paramStringBuilder, String paramString) {
        return StringUtils.quoteIdentifierOrLiteral(paramStringBuilder, paramString, '\"');
    }

    private static StringBuilder quoteIdentifierOrLiteral(StringBuilder paramStringBuilder, String paramString, char paramChar) {
        int i = paramStringBuilder.length();
        paramStringBuilder.append(paramChar);
        int j = 0;
        int k = paramString.length();
        while (j < k) {
            char c1 = (char)paramString.codePointAt(j);
            j += Character.charCount(c1);
            if (c1 < ' ' || c1 > '\u007f') {
                paramStringBuilder.setLength(i);
                paramStringBuilder.append("U&").append(paramChar);
                j = 0;
                while (j < k) {
                    c1 = (char)paramString.codePointAt(j);
                    j += Character.charCount(c1);
                    if (c1 >= ' ' && c1 < '\u007f') {
                        char c2 = c1;
                        if (c2 == paramChar || c2 == '\\') {
                            paramStringBuilder.append(c2);
                        }
                        paramStringBuilder.append(c2);
                        continue;
                    }
                    if (c1 <= '\uffff') {
                        StringUtils.appendHex(paramStringBuilder.append('\\'), c1, 2);
                        continue;
                    }
                    StringUtils.appendHex(paramStringBuilder.append("\\+"), c1, 3);
                }
            }
            if (c1 == paramChar) {
                paramStringBuilder.append(paramChar);
            }
            paramStringBuilder.append(c1);
        }
        return paramStringBuilder.append(paramChar);
    }

    public static boolean isNullOrEmpty(String paramString) {
        return paramString == null || paramString.isEmpty();
    }

    public static String pad(String paramString1, int paramInt, String paramString2, boolean paramBoolean) {
        if (paramInt < 0) {
            paramInt = 0;
        }
        if (paramInt < paramString1.length()) {
            return paramString1.substring(0, paramInt);
        }
        if (paramInt == paramString1.length()) {
            return paramString1;
        }
        char c = paramString2 == null || paramString2.isEmpty() ? (char)' ' : (char)paramString2.charAt(0);
        StringBuilder localStringBuilder = new StringBuilder(paramInt);
        paramInt -= paramString1.length();
        if (paramBoolean) {
            localStringBuilder.append(paramString1);
        }
        for (int i = 0; i < paramInt; ++i) {
            localStringBuilder.append(c);
        }
        if (!paramBoolean) {
            localStringBuilder.append(paramString1);
        }
        return localStringBuilder.toString();
    }

    public static char[] cloneCharArray(char[] paramArrayOfChar) {
        if (paramArrayOfChar == null) {
            return null;
        }
        int i = paramArrayOfChar.length;
        if (i == 0) {
            return paramArrayOfChar;
        }
        return Arrays.copyOf(paramArrayOfChar, i);
    }

    public static String trim(String paramString1, boolean paramBoolean1, boolean paramBoolean2, String paramString2) {
        int j;
        char i = paramString2 == null || paramString2.isEmpty() ? (char)' ' : (char)paramString2.charAt(0);
        int k = paramString1.length();
        if (paramBoolean1) {
            for (j = 0; j < k && paramString1.charAt(j) == i; ++j) {
            }
        }
        if (paramBoolean2) {
            while (k > j && paramString1.charAt(k - 1) == i) {
                --k;
            }
        }
        return paramString1.substring(j, k);
    }

    public static String trimSubstring(String paramString, int paramInt) {
        return StringUtils.trimSubstring(paramString, paramInt, paramString.length());
    }

    public static String trimSubstring(String paramString, int paramInt1, int paramInt2) {
        while (paramInt1 < paramInt2 && paramString.charAt(paramInt1) <= ' ') {
            ++paramInt1;
        }
        while (paramInt1 < paramInt2 && paramString.charAt(paramInt2 - 1) <= ' ') {
            --paramInt2;
        }
        return paramString.substring(paramInt1, paramInt2);
    }

    public static StringBuilder trimSubstring(StringBuilder paramStringBuilder, String paramString, int paramInt1, int paramInt2) {
        while (paramInt1 < paramInt2 && paramString.charAt(paramInt1) <= ' ') {
            ++paramInt1;
        }
        while (paramInt1 < paramInt2 && paramString.charAt(paramInt2 - 1) <= ' ') {
            --paramInt2;
        }
        return paramStringBuilder.append(paramString, paramInt1, paramInt2);
    }

    public static String truncateString(String paramString, int paramInt) {
        if (paramString.length() > paramInt) {
            paramString = paramInt > 0 ? paramString.substring(0, Character.isSurrogatePair(paramString.charAt(paramInt - 1), paramString.charAt(paramInt)) ? paramInt - 1 : paramInt) : "";
        }
        return paramString;
    }

    public static String cache(String paramString) {
        return paramString;
    }

    public static void clearCache() {
        softCache = null;
    }

    public static int parseUInt31(String paramString, int paramInt1, int paramInt2) {
        if (paramInt2 > paramString.length() || paramInt1 < 0 || paramInt1 > paramInt2) {
            throw new IndexOutOfBoundsException();
        }
        if (paramInt1 == paramInt2) {
            throw new NumberFormatException("");
        }
        int i = 0;
        for (int j = paramInt1; j < paramInt2; ++j) {
            char k = paramString.charAt(j);
            if (k < '0' || k > '9' || i > 0xCCCCCCC) {
                throw new NumberFormatException(paramString.substring(paramInt1, paramInt2));
            }
            if ((i = i * 10 + k - 48) >= 0) continue;
            throw new NumberFormatException(paramString.substring(paramInt1, paramInt2));
        }
        return i;
    }

    public static byte[] convertHexToBytes(String paramString) {
        int i = paramString.length();
        if (i % 2 != 0) {
            throw new RuntimeException(paramString);
        }
        byte[] arrayOfByte = new byte[i /= 2];
        int j = 0;
        int[] arrayOfInt = HEX_DECODE;
        try {
            for (int k = 0; k < i; ++k) {
                int m = arrayOfInt[paramString.charAt(k + k)] << 4 | arrayOfInt[paramString.charAt(k + k + 1)];
                j |= m;
                arrayOfByte[k] = (byte)m;
            }
        }
        catch (ArrayIndexOutOfBoundsException localArrayIndexOutOfBoundsException) {
            throw new RuntimeException(paramString);
        }
        if ((j & 0xFFFFFF00) != 0) {
            throw new RuntimeException(paramString);
        }
        return arrayOfByte;
    }

    public static ByteArrayOutputStream convertHexWithSpacesToBytes(ByteArrayOutputStream paramByteArrayOutputStream, String paramString, int paramInt1, int paramInt2) {
        if (paramByteArrayOutputStream == null) {
            paramByteArrayOutputStream = new ByteArrayOutputStream(paramInt2 - paramInt1 >>> 1);
        }
        int i = 0;
        int[] arrayOfInt = HEX_DECODE;
        try {
            int j = paramInt1;
            while (j < paramInt2) {
                char m;
                char k;
                if ((k = paramString.charAt(j++)) == ' ') continue;
                do {
                    if (j < paramInt2) continue;
                    if (((i | arrayOfInt[k]) & 0xFFFFFF00) != 0) {
                        throw StringUtils.getHexStringException(90004, paramString, paramInt1, paramInt2);
                    }
                    throw StringUtils.getHexStringException(90003, paramString, paramInt1, paramInt2);
                } while ((m = paramString.charAt(j++)) == ' ');
                int n = arrayOfInt[k] << 4 | arrayOfInt[m];
                i |= n;
                paramByteArrayOutputStream.write(n);
            }
        }
        catch (ArrayIndexOutOfBoundsException localArrayIndexOutOfBoundsException) {
            throw StringUtils.getHexStringException(90004, paramString, paramInt1, paramInt2);
        }
        if ((i & 0xFFFFFF00) != 0) {
            throw StringUtils.getHexStringException(90004, paramString, paramInt1, paramInt2);
        }
        return paramByteArrayOutputStream;
    }

    private static RuntimeException getHexStringException(int paramInt1, String paramString, int paramInt2, int paramInt3) {
        return new RuntimeException(paramInt1 + ":" + paramString.substring(paramInt2, paramInt3));
    }

    public static String convertBytesToHex(byte[] paramArrayOfByte) {
        return StringUtils.convertBytesToHex(paramArrayOfByte, paramArrayOfByte.length);
    }

    public static String convertBytesToHex(byte[] paramArrayOfByte, int paramInt) {
        byte[] arrayOfByte = new byte[paramInt * 2];
        char[] arrayOfChar = HEX;
        int j = 0;
        for (int i = 0; i < paramInt; ++i) {
            int k = paramArrayOfByte[i] & 0xFF;
            arrayOfByte[j++] = (byte)arrayOfChar[k >> 4];
            arrayOfByte[j++] = (byte)arrayOfChar[k & 0xF];
        }
        return new String(arrayOfByte, StandardCharsets.ISO_8859_1);
    }

    public static StringBuilder convertBytesToHex(StringBuilder paramStringBuilder, byte[] paramArrayOfByte) {
        return StringUtils.convertBytesToHex(paramStringBuilder, paramArrayOfByte, paramArrayOfByte.length);
    }

    public static StringBuilder convertBytesToHex(StringBuilder paramStringBuilder, byte[] paramArrayOfByte, int paramInt) {
        char[] arrayOfChar = HEX;
        for (int i = 0; i < paramInt; ++i) {
            int j = paramArrayOfByte[i] & 0xFF;
            paramStringBuilder.append(arrayOfChar[j >>> 4]).append(arrayOfChar[j & 0xF]);
        }
        return paramStringBuilder;
    }

    public static StringBuilder appendHex(StringBuilder paramStringBuilder, long paramLong, int paramInt) {
        char[] arrayOfChar = HEX;
        int i = paramInt * 8;
        while (i > 0) {
            i -= 4;
            paramStringBuilder.append(arrayOfChar[(int)(paramLong >> (i -= 4)) & 0xF]).append(arrayOfChar[(int)(paramLong >> i) & 0xF]);
        }
        return paramStringBuilder;
    }

    public static boolean isNumber(String paramString) {
        int i = paramString.length();
        if (i == 0) {
            return false;
        }
        for (int j = 0; j < i; ++j) {
            if (Character.isDigit(paramString.charAt(j))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespaceOrEmpty(String paramString) {
        int j = paramString.length();
        for (int i = 0; i < j; ++i) {
            if (paramString.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static StringBuilder appendTwoDigits(StringBuilder paramStringBuilder, int paramInt) {
        if (paramInt < 10) {
            paramStringBuilder.append('0');
        }
        return paramStringBuilder.append(paramInt);
    }

    public static StringBuilder appendZeroPadded(StringBuilder paramStringBuilder, int paramInt, long paramLong) {
        String str = Long.toString(paramLong);
        paramInt -= str.length();
        while (paramInt > 0) {
            paramStringBuilder.append('0');
            --paramInt;
        }
        return paramStringBuilder.append(str);
    }

    public static String escapeMetaDataPattern(String paramString) {
        if (paramString == null || paramString.isEmpty()) {
            return paramString;
        }
        return StringUtils.replaceAll(paramString, "\\", "\\\\");
    }

    static {
        int i;
        HEX = "0123456789abcdef".toCharArray();
        HEX_DECODE = new int[103];
        TO_UPPER_CACHE = new String[2048][];
        for (i = 0; i < HEX_DECODE.length; ++i) {
            StringUtils.HEX_DECODE[i] = -1;
        }
        for (i = 0; i <= 9; ++i) {
            StringUtils.HEX_DECODE[i + 48] = i;
        }
        for (i = 0; i <= 5; ++i) {
            int tmp94_93;
            StringUtils.HEX_DECODE[i + 65] = tmp94_93 = i + 10;
            StringUtils.HEX_DECODE[i + 97] = tmp94_93;
        }
    }
}

