/*
 * Decompiled with CFR 0.152.
 */
package weaver.agent.net.sf.json.util;

import weaver.agent.net.sf.ezmorph.ObjectMorpher;

public class EnumMorpher
implements ObjectMorpher {
    private Class enumClass;

    public EnumMorpher(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("enumClass is null");
        }
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("enumClass is not an Enum class");
        }
        this.enumClass = enumClass;
    }

    public Object morph(Object value) {
        if (value == null) {
            return this.enumClass.cast(null);
        }
        return Enum.valueOf(this.enumClass, String.valueOf(value));
    }

    public Class morphsTo() {
        return this.enumClass;
    }

    public boolean supports(Class clazz) {
        return String.class.isAssignableFrom(clazz);
    }
}

