/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect.agent.template.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weaver.agent.javassist.CannotCompileException;
import weaver.agent.javassist.CtBehavior;
import weaver.agent.javassist.CtClass;
import weaver.agent.javassist.CtConstructor;
import weaver.security.protect.agent.ABaseAgent;
import weaver.security.protect.entity.MethodEntity;
import weaver.security.protect.utils.JavassistUtil;
import weaver.security.protect.utils.LogWriter;
import weaver.security.protect.wrapper.ResponseWrapper;

public class FileTypeAgentTemplate
extends ABaseAgent {
    private Map<String, String> fileConstructorCode = new HashMap<String, String>();

    public FileTypeAgentTemplate() {
        this.fileConstructorCode.put("java.io.FileOutputStream(java.lang.String)", this.fileOutputStream_javaLangString_code());
        this.fileConstructorCode.put("java.io.FileOutputStream(java.lang.String,boolean)", this.fileOutputStream_javaLangString_boolean_code());
        this.fileConstructorCode.put("java.io.FileOutputStream(java.io.File)", this.fileOutputStream_javaIoFile_code());
    }

    @Override
    public ResponseWrapper doEnhanceClass(CtClass ctClass) throws Exception {
        List<MethodEntity> methods = super.getClassEntity().getMethods();
        try {
            for (MethodEntity method : methods) {
                CtBehavior ctConstructor = JavassistUtil.getCtMethodAndCtConstructor(this.getClassEntity().getTargetClassName(), method, ctClass);
                this.insertCodeBefore(ctConstructor, method.getParamIndex());
            }
        }
        catch (Exception e) {
            CtConstructor[] constructors;
            LogWriter.writeError("enhance java.io.FileOutputStream(java.io.File,boolean) error\uff0cexception \uff1a", e);
            for (CtConstructor constructor : constructors = ctClass.getConstructors()) {
                String code = this.fileConstructorCode.get(constructor.getLongName());
                if (code == null) continue;
                this.insertCodeBeforeAgain(constructor, code);
            }
        }
        return new ResponseWrapper(ctClass, super.getClassEntity());
    }

    public void insertCodeBefore(CtBehavior ctConstructor, String paramIndex) throws CannotCompileException {
        String insertBeforeStr = "";
        insertBeforeStr = "String path_ = $1.getPath();\n" + this.commonCode();
        if (ctConstructor != null) {
            ctConstructor.insertBefore(insertBeforeStr);
        }
    }

    public void insertCodeBeforeAgain(CtBehavior ctConstructor, String code) throws CannotCompileException {
        if (ctConstructor != null) {
            ctConstructor.insertBefore(code);
        }
    }

    @Override
    public String getCheckRule() {
        return "fileTypeCheck";
    }

    public String fileOutputStream_javaLangString_code() {
        String code = "String path_ = $1;\n";
        code = code + this.commonCode();
        return code;
    }

    public String fileOutputStream_javaLangString_boolean_code() {
        String code = "String path_ = $1;\n";
        code = code + this.commonCode();
        return code;
    }

    public String fileOutputStream_javaIoFile_code() {
        String code = "String path_ = $1.getPath();\n";
        code = code + this.commonCode();
        return code;
    }

    private String commonCode() {
        String strCode = "if (path_ == null) {\n            path_ = \"\";\n        }\n\n        if (path_.contains(\"../\") || path_.contains(\"..\\\\\") || path_.contains(\"\\\u0000\")) {\n            throw new RuntimeException(\"[security reject]\u5199\u51fa\u8def\u5f84\u4e0d\u5408\u89c4\uff1a\" + path_);\n        }\n\n        // \u83b7\u53d6\u8bf7\u6c42uri\n        String value_ = \"\";\n        try {\n            java.lang.Class aClass_ = Class.forName(\"weaver.security.protect.bridge.bridge.RequestPathBridge\");\n            value_ = aClass_.getMethod(\"getValue\",null).invoke(null,null).toString();\n        } catch (java.lang.Exception exception) {\n            System.out.println(\"\u589e\u5f3aFile\u6e90\u7801\u5f02\u5e38\uff1a\" + exception.toString());\n            value_ = \"\";\n        }\n\n        if (!value_.equals(\"\")) {\n            value_ = value_.toLowerCase();\n            path_ = path_.replaceAll(\"/+\",\"/\");\n            path_ = path_.replaceAll(\"\\\\\\\\+\",\"/\").toLowerCase();\n\n            if (path_.contains(\"./\")) {\n                System.out.println(\">>agent file path check only log, path_= \" + path_ + \" url = \" + value_);\n            }\n\n            String fileNotAllowWrite = System.getProperty(\"fileNotAllowWrite\");\n            if (fileNotAllowWrite != null && !fileNotAllowWrite.contains(\"*.*\")) {\n                String[] fileNotAllowWriteSplit = fileNotAllowWrite.split(\",\");\n                for (int i = 0; i < fileNotAllowWriteSplit.length; i++) {\n                    String suffix = fileNotAllowWriteSplit[i];\n                    if (path_.contains(suffix)) {\n                        String skipWriteUrlCheck = System.getProperty(\"skipWriteUrlCheck\");\n                        String skipWritePathCheck = System.getProperty(\"skipWritePathCheck\");\n                        String agentRootPath = System.getProperty(\"agent-root-path\");\n                        if (skipWriteUrlCheck != null && skipWritePathCheck != null) {\n                            boolean flag = false;\n                            String[] skipWriteUrlCheckSplit = skipWriteUrlCheck.split(\",\");\n                            for (int m = 0; m < skipWriteUrlCheckSplit.length; m++) {\n                                String writeUrl = skipWriteUrlCheckSplit[m];\n                                if (value_.startsWith(writeUrl)) {\n                                    flag = true;\n                                }\n                            }\n                            if (!flag) {\n                                String[] skipWritePathCheckSplit = skipWritePathCheck.split(\",\");\n                                for (int j = 0; j < skipWritePathCheckSplit.length; j++) {\n                                    String writePath = skipWritePathCheckSplit[j];\n                                    if (path_.startsWith(writePath)) {\n                                        flag = true;\n                                    }\n                                }\n                            }\n                            if (!flag && agentRootPath !=null && !path_.contains(agentRootPath)) {\n                                flag = true;\n                            }\n                            if (!flag) {\n                                throw new RuntimeException(\"[security reject]\u63a5\u53e3\u6216\u8005\u5199\u51fa\u8def\u5f84\u4e0d\u5141\u8bb8\uff0curi=\" + value_ + \" path=\" + path_);\n                            }\n                        }\n                    }\n                }\n            }\n        }";
        return strCode;
    }

    public void aa() throws Exception {
        String path_ = "";
        if (path_ == null) {
            path_ = "";
        }
        if (path_.contains("../") || path_.contains("..\\") || path_.contains("\u0000")) {
            throw new RuntimeException("[security reject]\u5199\u51fa\u8def\u5f84\u4e0d\u5408\u89c4\uff1a" + path_);
        }
        String value_ = "";
        try {
            Class<?> aClass_ = Class.forName("weaver.security.protect.bridge.bridge.RequestPathBridge");
            value_ = aClass_.getMethod("getValue", null).invoke(null, null).toString();
        }
        catch (Exception exception) {
            System.out.println("\u589e\u5f3aFile\u6e90\u7801\u5f02\u5e38\uff1a" + exception.toString());
            value_ = "";
        }
        if (!value_.equals("")) {
            String fileNotAllowWrite;
            value_ = value_.toLowerCase();
            path_ = path_.replaceAll("/+", "/");
            if ((path_ = path_.replaceAll("\\\\+", "/").toLowerCase()).contains("./")) {
                System.out.println(">>agent file path check only log, path_= " + path_ + " url = " + value_);
            }
            if ((fileNotAllowWrite = System.getProperty("fileNotAllowWrite")) != null && !fileNotAllowWrite.contains("*.*")) {
                String[] fileNotAllowWriteSplit = fileNotAllowWrite.split(",");
                for (int i = 0; i < fileNotAllowWriteSplit.length; ++i) {
                    String suffix = fileNotAllowWriteSplit[i];
                    if (!path_.contains(suffix)) continue;
                    String skipWriteUrlCheck = System.getProperty("skipWriteUrlCheck");
                    String skipWritePathCheck = System.getProperty("skipWritePathCheck");
                    String agentRootPath = System.getProperty("agent-root-path");
                    if (skipWriteUrlCheck == null || skipWritePathCheck == null) continue;
                    boolean flag = false;
                    String[] skipWriteUrlCheckSplit = skipWriteUrlCheck.split(",");
                    for (int m = 0; m < skipWriteUrlCheckSplit.length; ++m) {
                        String writeUrl = skipWriteUrlCheckSplit[m];
                        if (!value_.startsWith(writeUrl)) continue;
                        flag = true;
                    }
                    if (!flag) {
                        String[] skipWritePathCheckSplit = skipWritePathCheck.split(",");
                        for (int j = 0; j < skipWritePathCheckSplit.length; ++j) {
                            String writePath = skipWritePathCheckSplit[j];
                            if (!path_.startsWith(writePath)) continue;
                            flag = true;
                        }
                    }
                    if (!flag && agentRootPath != null && !path_.contains(agentRootPath)) {
                        flag = true;
                    }
                    if (flag) continue;
                    throw new RuntimeException("[security reject]\u63a5\u53e3\u6216\u8005\u5199\u51fa\u8def\u5f84\u4e0d\u5141\u8bb8\uff0curi=" + value_ + " path=" + path_);
                }
            }
        }
    }
}

