/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import weaver.agent.javassist.CtClass;
import weaver.security.protect.cache.RuleConfigCache;
import weaver.security.protect.utils.LogWriter;

public class FileUtil {
    public static void clearFile(String path) {
        try {
            File file;
            if (path == null || path.length() == 0) {
                path = RuleConfigCache.getWritePathCache();
            }
            if ((file = new File(path)).exists() && file.listFiles().length > 0) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    if (f.isDirectory()) continue;
                    f.delete();
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("\u5220\u9664\u6587\u4ef6\u5939\u4e2d\u7684\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a" + e);
        }
    }

    public static void clearEnhanceFile() {
        String writePath = RuleConfigCache.getWritePathCache();
        FileUtil.clearFile(writePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClassFile(CtClass ctClass) {
        FileOutputStream fileOutputStream = null;
        try {
            String rootPath = RuleConfigCache.getWritePathCache();
            FileUtil.checkAndCreate(rootPath);
            byte[] bytes = ctClass.toBytecode();
            fileOutputStream = new FileOutputStream(new File(rootPath, ctClass.getSimpleName() + ".class.enhance"));
            fileOutputStream.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            LogWriter.writeLog("\u589e\u5f3a\u6587\u4ef6\u5199\u51fa\u51fa\u73b0\u5f02\u5e38\uff1a" + e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeClassFile(String path, CtClass ctClass) {
        FileOutputStream fileOutputStream = null;
        try {
            byte[] bytes = ctClass.toBytecode();
            fileOutputStream = new FileOutputStream(new File(path + ctClass.getSimpleName() + ".class"));
            fileOutputStream.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u5199\u5165\u78c1\u76d8\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeClassFile(String path, byte[] bytes) {
        FileOutputStream fileOutputStream = null;
        try {
            String filePath = path.substring(0, path.lastIndexOf("/"));
            FileUtil.checkAndCreate(filePath);
            fileOutputStream = new FileOutputStream(new File(path));
            fileOutputStream.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            LogWriter.writeError("\u6e90\u6587\u4ef6\u5199\u5165\u78c1\u76d8\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readToByte(String path) {
        FileInputStream inputStream = null;
        ByteArrayOutputStream outStream = null;
        byte[] bytes = null;
        try {
            int len = 0;
            inputStream = new FileInputStream(new File(path));
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            bytes = outStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bytes;
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean isFileExists(String path) {
        File file = new File(path);
        return FileUtil.isFileExists(file);
    }

    public static void checkAndCreate(String path) {
        File file = new File(path);
        try {
            if (!FileUtil.isFileExists(file)) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
    }
}

