/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.StringUtils;

public interface PathUtils {
    public static String buildPath(String rootPath, String ... subPaths) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(rootPath);
        paths.addAll(Arrays.asList(subPaths));
        return PathUtils.normalize(paths.stream().filter(StringUtils::isNotEmpty).collect(Collectors.joining(StringUtils.SLASH)));
    }

    public static String normalize(String path) {
        if (StringUtils.isEmpty(path)) {
            return StringUtils.SLASH;
        }
        String normalizedPath = path;
        int index = normalizedPath.indexOf(StringUtils.QUESTION_MASK);
        if (index > -1) {
            normalizedPath = normalizedPath.substring(0, index);
        }
        while (normalizedPath.contains("//")) {
            normalizedPath = StringUtils.replace(normalizedPath, "//", "/");
        }
        return normalizedPath;
    }
}

