/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.dubbo.common.utils.TypeUtils;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class MapTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        if (!(type instanceof ParameterizedType)) {
            return new TypeDefinition(clazz.getName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        int actualTypeArgsLength = actualTypeArgs == null ? 0 : actualTypeArgs.length;
        String mapType = type.toString();
        TypeDefinition typeDefinition = new TypeDefinition(mapType);
        for (int i = 0; i < actualTypeArgsLength; ++i) {
            Type actualType = actualTypeArgs[i];
            TypeDefinition item = null;
            Class<?> rawType = TypeUtils.getRawClass(actualType);
            if (TypeUtils.isParameterizedType(actualType)) {
                item = TypeDefinitionBuilder.build(actualType, rawType, typeCache);
            } else if (TypeUtils.isClass(actualType)) {
                item = TypeDefinitionBuilder.build(null, rawType, typeCache);
            }
            typeDefinition.getItems().add(item);
        }
        return typeDefinition;
    }
}

