/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;

public class NacosServiceDiscovery
extends AbstractServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String group;
    private NacosNamingServiceWrapper namingService;
    private URL registryURL;

    @Override
    public void initialize(URL registryURL) throws Exception {
        this.namingService = NacosNamingServiceUtils.createNamingService(registryURL);
        this.group = NacosNamingServiceUtils.getGroup(registryURL);
        this.registryURL = registryURL;
    }

    @Override
    public void destroy() {
        this.namingService = null;
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) {
        ThrowableConsumer.execute(this.namingService, service -> {
            Instance instance = NacosNamingServiceUtils.toInstance(serviceInstance);
            this.appendPreservedParam(instance);
            service.registerInstance(instance.getServiceName(), this.group, instance);
        });
    }

    @Override
    public void doUpdate(ServiceInstance serviceInstance) {
        if (this.serviceInstance == null) {
            this.register(serviceInstance);
        } else {
            this.unregister(serviceInstance);
            this.register(serviceInstance);
        }
    }

    @Override
    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        ThrowableConsumer.execute(this.namingService, service -> {
            Instance instance = NacosNamingServiceUtils.toInstance(serviceInstance);
            service.deregisterInstance(instance.getServiceName(), this.group, instance);
        });
    }

    @Override
    public Set<String> getServices() {
        return ThrowableFunction.execute(this.namingService, service -> {
            ListView<String> view = service.getServicesOfServer(0, Integer.MAX_VALUE, this.group);
            return new LinkedHashSet(view.getData());
        });
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        return ThrowableFunction.execute(this.namingService, service -> service.selectInstances(serviceName, true).stream().map(NacosNamingServiceUtils::toServiceInstance).collect(Collectors.toList()));
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        ThrowableConsumer.execute(this.namingService, service -> listener.getServiceNames().forEach(serviceName -> {
            try {
                service.subscribe((String)serviceName, e -> {
                    if (e instanceof NamingEvent) {
                        NamingEvent event = (NamingEvent)e;
                        this.handleEvent(event, listener);
                    }
                });
            }
            catch (NacosException e2) {
                e2.printStackTrace();
            }
        }));
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    private void handleEvent(NamingEvent event, ServiceInstancesChangedListener listener) {
        String serviceName = NamingUtils.getServiceName((String)event.getServiceName());
        List<ServiceInstance> serviceInstances = event.getInstances().stream().map(NacosNamingServiceUtils::toServiceInstance).collect(Collectors.toList());
        this.dispatchServiceInstancesChangedEvent(serviceName, serviceInstances);
    }

    private void appendPreservedParam(Instance instance) {
        Map<String, String> preservedParam = NacosNamingServiceUtils.getNacosPreservedParam(this.getUrl());
        instance.getMetadata().putAll(preservedParam);
    }
}

