/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.rest.RestConstraintViolation;
import org.apache.dubbo.rpc.protocol.rest.ViolationReport;

public class RpcExceptionMapper
implements ExceptionMapper<RpcException> {
    public Response toResponse(RpcException e) {
        if (e.getCause() instanceof ConstraintViolationException) {
            return this.handleConstraintViolationException((ConstraintViolationException)e.getCause());
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Internal server error: " + e.getMessage())).type("text/plain; charset=UTF-8").build();
    }

    protected Response handleConstraintViolationException(ConstraintViolationException cve) {
        ViolationReport report = new ViolationReport();
        for (ConstraintViolation cv : cve.getConstraintViolations()) {
            report.addConstraintViolation(new RestConstraintViolation(cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString()));
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)report).type("text/xml; charset=UTF-8").build();
    }
}

