/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.etcd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.remoting.etcd.jetcd.JEtcdClient;

public class EtcdMetadataReport
extends AbstractMetadataReport {
    private final String root;
    private final JEtcdClient etcdClient;

    public EtcdMetadataReport(URL url) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getParameter("group", "dubbo");
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.etcdClient = new JEtcdClient(url);
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    @Override
    protected void doSaveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier, URL url) {
        String key = this.getNodeKey(serviceMetadataIdentifier);
        if (!this.etcdClient.put(key, URL.encode(url.toFullString()))) {
            this.logger.error("Failed to put " + serviceMetadataIdentifier + " to etcd, value: " + url);
        }
    }

    @Override
    protected void doRemoveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier) {
        this.etcdClient.delete(this.getNodeKey(serviceMetadataIdentifier));
    }

    @Override
    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.etcdClient.getKVValue(this.getNodeKey(metadataIdentifier));
        if (StringUtils.isEmpty(content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode(content)));
    }

    @Override
    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        String key = this.getNodeKey(subscriberMetadataIdentifier);
        if (!this.etcdClient.put(key, urlListStr)) {
            this.logger.error("Failed to put " + subscriberMetadataIdentifier + " to etcd, value: " + urlListStr);
        }
    }

    @Override
    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.etcdClient.getKVValue(this.getNodeKey(subscriberMetadataIdentifier));
    }

    @Override
    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.etcdClient.getKVValue(this.getNodeKey(metadataIdentifier));
    }

    private void storeMetadata(MetadataIdentifier identifier, String v) {
        String key = this.getNodeKey(identifier);
        if (!this.etcdClient.put(key, v)) {
            this.logger.error("Failed to put " + identifier + " to etcd, value: " + v);
        }
    }

    String getNodeKey(BaseMetadataIdentifier identifier) {
        return this.toRootDir() + identifier.getUniqueKey(KeyTypeEnum.PATH);
    }

    String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }
}

