/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.consul;

import com.ecwid.consul.v1.ConsistencyMode;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.event.EventListener;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.consul.ConsulParameter;

public class ConsulServiceDiscovery
extends AbstractServiceDiscovery
implements EventListener<ServiceInstancesChangedEvent> {
    private static final String QUERY_TAG = "consul_query_tag";
    private static final String REGISTER_TAG = "consul_register_tag";
    private List<String> registeringTags = new ArrayList<String>();
    private String tag;
    private ConsulClient client;
    private ExecutorService notifierExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("dubbo-service-discovery-consul-notifier", true));
    private Map<String, ConsulNotifier> notifiers = new ConcurrentHashMap<String, ConsulNotifier>();
    private TtlScheduler ttlScheduler;
    private long checkPassInterval;
    private URL url;
    private String aclToken;
    private List<String> tags;
    private ConsistencyMode consistencyMode;
    private String defaultZoneMetadataName;
    private String instanceZone;
    private String instanceGroup;

    @Override
    public void onEvent(ServiceInstancesChangedEvent event) {
    }

    @Override
    public void initialize(URL registryURL) throws Exception {
        this.url = registryURL;
        String host = this.url.getHost();
        int port = 0 != this.url.getPort() ? this.url.getPort() : 8500;
        this.checkPassInterval = this.url.getParameter("consul-check-pass-interval", 16000L);
        this.client = new ConsulClient(host, port);
        this.ttlScheduler = new TtlScheduler(this.checkPassInterval, this.client);
        this.tag = registryURL.getParameter(QUERY_TAG);
        this.registeringTags.addAll(this.getRegisteringTags(this.url));
        this.aclToken = ConsulParameter.ACL_TOKEN.getValue(registryURL);
        this.tags = this.getTags(registryURL);
        this.consistencyMode = this.getConsistencyMode(registryURL);
        this.defaultZoneMetadataName = ConsulParameter.DEFAULT_ZONE_METADATA_NAME.getValue(registryURL);
        this.instanceZone = ConsulParameter.INSTANCE_ZONE.getValue(registryURL);
        this.instanceGroup = ConsulParameter.INSTANCE_GROUP.getValue(registryURL);
    }

    private ConsistencyMode getConsistencyMode(URL registryURL) {
        String value = ConsulParameter.CONSISTENCY_MODE.getValue(registryURL);
        if (StringUtils.isNotEmpty(value)) {
            return ConsistencyMode.valueOf((String)value);
        }
        return ConsistencyMode.DEFAULT;
    }

    private List<String> getTags(URL registryURL) {
        String value = ConsulParameter.TAGS.getValue(registryURL);
        return StringUtils.splitToList(value, ',');
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    private List<String> getRegisteringTags(URL url) {
        ArrayList<String> tags = new ArrayList<String>();
        String rawTag = url.getParameter(REGISTER_TAG);
        if (StringUtils.isNotEmpty(rawTag)) {
            tags.addAll(Arrays.asList(CommonConstants.SEMICOLON_SPLIT_PATTERN.split(rawTag)));
        }
        return tags;
    }

    @Override
    public void destroy() {
        this.notifiers.forEach((_k, notifier) -> {
            if (notifier != null) {
                notifier.stop();
            }
        });
        this.notifiers.clear();
        this.notifierExecutor.shutdownNow();
        this.ttlScheduler.stop();
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) {
        NewService consulService = this.buildService(serviceInstance);
        this.ttlScheduler.add(consulService.getId());
        this.client.agentServiceRegister(consulService, this.aclToken);
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        Set<String> serviceNames = listener.getServiceNames();
        for (String serviceName : serviceNames) {
            ConsulNotifier notifier = this.notifiers.get(serviceName);
            if (notifier == null) {
                Response<List<HealthService>> response = this.getHealthServices(serviceName, -1L, this.buildWatchTimeout());
                Long consulIndex = response.getConsulIndex();
                notifier = new ConsulNotifier(serviceName, consulIndex);
            }
            this.notifierExecutor.execute(notifier);
        }
    }

    @Override
    public void doUpdate(ServiceInstance serviceInstance) {
    }

    @Override
    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        String id = this.buildId(serviceInstance);
        this.ttlScheduler.remove(id);
        this.client.agentServiceDeregister(id, this.aclToken);
    }

    @Override
    public Set<String> getServices() {
        CatalogServicesRequest request = CatalogServicesRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).setToken(this.aclToken).build();
        return ((Map)this.client.getCatalogServices(request).getValue()).keySet();
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        Response<List<HealthService>> response = this.getHealthServices(serviceName, -1L, this.buildWatchTimeout());
        Long consulIndex = response.getConsulIndex();
        ConsulNotifier notifier = this.notifiers.get(serviceName);
        if (notifier == null) {
            notifier = new ConsulNotifier(serviceName, consulIndex);
            this.notifiers.put(serviceName, notifier);
        }
        return this.convert((List)response.getValue());
    }

    private List<ServiceInstance> convert(List<HealthService> services) {
        return services.stream().map(HealthService::getService).map(service -> {
            DefaultServiceInstance instance = new DefaultServiceInstance(service.getId(), service.getService(), service.getAddress(), service.getPort());
            instance.getMetadata().putAll(this.getMetadata((HealthService.Service)service));
            return instance;
        }).collect(Collectors.toList());
    }

    private Response<List<HealthService>> getHealthServices(String service, long index, int watchTimeout) {
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setTag(this.tag).setQueryParams(new QueryParams((long)watchTimeout, index)).setPassing(true).build();
        return this.client.getHealthServices(service, request);
    }

    private Map<String, String> getMetadata(HealthService.Service service) {
        Map<String, String> metadata = service.getMeta();
        if (CollectionUtils.isEmptyMap(metadata = this.decodeMetadata(metadata))) {
            metadata = this.getScCompatibleMetadata(service.getTags());
        }
        return metadata;
    }

    private Map<String, String> getScCompatibleMetadata(List<String> tags) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        if (tags != null) {
            block5: for (String tag : tags) {
                String[] parts = StringUtils.delimitedListToStringArray(tag, "=");
                switch (parts.length) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        metadata.put(parts[0], parts[0]);
                        continue block5;
                    }
                    case 2: {
                        metadata.put(parts[0], parts[1]);
                        continue block5;
                    }
                }
                Object[] end = Arrays.copyOfRange(parts, 1, parts.length);
                metadata.put(parts[0], StringUtils.arrayToDelimitedString(end, "="));
            }
        }
        return metadata;
    }

    private NewService buildService(ServiceInstance serviceInstance) {
        NewService service = new NewService();
        service.setAddress(serviceInstance.getHost());
        service.setPort(serviceInstance.getPort());
        service.setId(this.buildId(serviceInstance));
        service.setName(serviceInstance.getServiceName());
        service.setCheck(this.buildCheck(serviceInstance));
        service.setTags(this.buildTags(serviceInstance));
        return service;
    }

    private String buildId(ServiceInstance serviceInstance) {
        return Integer.toHexString(serviceInstance.hashCode());
    }

    private List<String> buildTags(ServiceInstance serviceInstance) {
        LinkedList<String> tags = new LinkedList<String>(this.tags);
        if (StringUtils.isNotEmpty(this.instanceZone)) {
            tags.add(this.defaultZoneMetadataName + "=" + this.instanceZone);
        }
        if (StringUtils.isNotEmpty(this.instanceGroup)) {
            tags.add("group=" + this.instanceGroup);
        }
        Map<String, String> params = serviceInstance.getMetadata();
        params.keySet().stream().map(k -> k + "=" + (String)params.get(k)).forEach(tags::add);
        tags.addAll(this.registeringTags);
        return tags;
    }

    private Map<String, String> buildMetadata(ServiceInstance serviceInstance) {
        Map<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.putAll(this.getScCompatibleMetadata(this.registeringTags));
        if (CollectionUtils.isNotEmptyMap(serviceInstance.getMetadata())) {
            metadata.putAll(serviceInstance.getMetadata());
        }
        metadata = this.encodeMetadata(metadata);
        return metadata;
    }

    private Map<String, String> encodeMetadata(Map<String, String> metadata) {
        if (metadata == null) {
            return metadata;
        }
        HashMap<String, String> encoded = new HashMap<String, String>(metadata.size());
        metadata.forEach((k, v) -> encoded.put(Base64.getEncoder().encodeToString(k.getBytes()), (String)v));
        return encoded;
    }

    private Map<String, String> decodeMetadata(Map<String, String> metadata) {
        if (metadata == null) {
            return metadata;
        }
        HashMap<String, String> decoded = new HashMap<String, String>(metadata.size());
        metadata.forEach((k, v) -> decoded.put(new String(Base64.getDecoder().decode((String)k)), (String)v));
        return decoded;
    }

    private NewService.Check buildCheck(ServiceInstance serviceInstance) {
        NewService.Check check = new NewService.Check();
        check.setTtl(this.checkPassInterval / 1000L + "s");
        String deregister = serviceInstance.getMetadata().get("consul-deregister-critical-service-after");
        check.setDeregisterCriticalServiceAfter(deregister == null ? "20s" : deregister);
        return check;
    }

    private int buildWatchTimeout() {
        return this.url.getParameter("consul-watch-timeout", 60000) / 1000;
    }

    private static class TtlScheduler {
        private static final Logger logger = LoggerFactory.getLogger(TtlScheduler.class);
        private final Map<String, ScheduledFuture> serviceHeartbeats = new ConcurrentHashMap<String, ScheduledFuture>();
        private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        private long checkInterval;
        private ConsulClient client;

        public TtlScheduler(long checkInterval, ConsulClient client) {
            this.checkInterval = checkInterval;
            this.client = client;
        }

        public void add(String instanceId) {
            ScheduledFuture<?> task = this.scheduler.scheduleAtFixedRate(new ConsulHeartbeatTask(instanceId), this.checkInterval / 8L, this.checkInterval / 8L, TimeUnit.MILLISECONDS);
            ScheduledFuture<?> previousTask = this.serviceHeartbeats.put(instanceId, task);
            if (previousTask != null) {
                previousTask.cancel(true);
            }
        }

        public void remove(String instanceId) {
            ScheduledFuture task = this.serviceHeartbeats.get(instanceId);
            if (task != null) {
                task.cancel(true);
            }
            this.serviceHeartbeats.remove(instanceId);
        }

        public void stop() {
            this.scheduler.shutdownNow();
        }

        private class ConsulHeartbeatTask
        implements Runnable {
            private String checkId;

            ConsulHeartbeatTask(String serviceId) {
                this.checkId = serviceId;
                if (!this.checkId.startsWith("service:")) {
                    this.checkId = "service:" + this.checkId;
                }
            }

            @Override
            public void run() {
                TtlScheduler.this.client.agentCheckPass(this.checkId);
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending consul heartbeat for: " + this.checkId);
                }
            }
        }
    }

    private class ConsulNotifier
    implements Runnable {
        private String serviceName;
        private long consulIndex;
        private boolean running;

        ConsulNotifier(String serviceName, long consulIndex) {
            this.serviceName = serviceName;
            this.consulIndex = consulIndex;
            this.running = true;
        }

        @Override
        public void run() {
            while (this.running) {
                this.processService();
            }
        }

        private void processService() {
            Response response = ConsulServiceDiscovery.this.getHealthServices(this.serviceName, this.consulIndex, Integer.MAX_VALUE);
            Long currentIndex = response.getConsulIndex();
            if (currentIndex != null && currentIndex > this.consulIndex) {
                this.consulIndex = currentIndex;
                List services = (List)response.getValue();
                List serviceInstances = ConsulServiceDiscovery.this.convert(services);
                ConsulServiceDiscovery.this.dispatchServiceInstancesChangedEvent(this.serviceName, serviceInstances);
            }
        }

        void stop() {
            this.running = false;
        }
    }
}

