/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.DefaultPage;
import org.apache.dubbo.common.utils.Page;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.zookeeper.ZookeeperInstance;
import org.apache.dubbo.registry.zookeeper.ZookeeperServiceDiscoveryChangeWatcher;
import org.apache.dubbo.registry.zookeeper.util.CuratorFrameworkParams;
import org.apache.dubbo.registry.zookeeper.util.CuratorFrameworkUtils;
import org.apache.zookeeper.KeeperException;

public class ZookeeperServiceDiscovery
extends AbstractServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private URL registryURL;
    private CuratorFramework curatorFramework;
    private String rootPath;
    private ServiceDiscovery<ZookeeperInstance> serviceDiscovery;
    private final Map<String, ZookeeperServiceDiscoveryChangeWatcher> watcherCaches = new ConcurrentHashMap<String, ZookeeperServiceDiscoveryChangeWatcher>();

    @Override
    public void initialize(URL registryURL) throws Exception {
        this.registryURL = registryURL;
        this.curatorFramework = CuratorFrameworkUtils.buildCuratorFramework(registryURL);
        this.rootPath = (String)CuratorFrameworkParams.ROOT_PATH.getParameterValue(registryURL);
        this.serviceDiscovery = CuratorFrameworkUtils.buildServiceDiscovery(this.curatorFramework, this.rootPath);
        this.serviceDiscovery.start();
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    @Override
    public void destroy() throws Exception {
        this.serviceDiscovery.close();
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) {
        this.doInServiceRegistry(serviceDiscovery -> serviceDiscovery.registerService(CuratorFrameworkUtils.build(serviceInstance)));
    }

    @Override
    public void doUpdate(ServiceInstance serviceInstance) {
        this.doInServiceRegistry(serviceDiscovery -> serviceDiscovery.updateService(CuratorFrameworkUtils.build(serviceInstance)));
    }

    @Override
    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.doInServiceRegistry(serviceDiscovery -> serviceDiscovery.unregisterService(CuratorFrameworkUtils.build(serviceInstance)));
    }

    @Override
    public Set<String> getServices() {
        return this.doInServiceDiscovery(s -> new LinkedHashSet(s.queryForNames()));
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        return this.doInServiceDiscovery(s -> CuratorFrameworkUtils.build(s.queryForInstances(serviceName)));
    }

    @Override
    public Page<ServiceInstance> getInstances(String serviceName, int offset, int pageSize, boolean healthyOnly) {
        String path = this.buildServicePath(serviceName);
        return ThrowableFunction.execute(path, p -> {
            LinkedList<ServiceInstance> serviceInstances = new LinkedList<ServiceInstance>();
            int totalSize = 0;
            try {
                int i;
                LinkedList serviceIds = new LinkedList((Collection)this.curatorFramework.getChildren().forPath(p));
                totalSize = serviceIds.size();
                Iterator iterator = serviceIds.iterator();
                for (i = 0; i < offset; ++i) {
                    if (!iterator.hasNext()) continue;
                    iterator.next();
                    iterator.remove();
                }
                for (i = 0; i < pageSize; ++i) {
                    if (!iterator.hasNext()) continue;
                    String serviceId = (String)iterator.next();
                    ServiceInstance serviceInstance = CuratorFrameworkUtils.build((org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance>)this.serviceDiscovery.queryForInstance(serviceName, serviceId));
                    serviceInstances.add(serviceInstance);
                }
                if (healthyOnly) {
                    Iterator instanceIterator = serviceInstances.iterator();
                    while (instanceIterator.hasNext()) {
                        ServiceInstance instance = (ServiceInstance)instanceIterator.next();
                        if (instance.isHealthy()) continue;
                        instanceIterator.remove();
                    }
                }
            }
            catch (KeeperException.NoNodeException e) {
                this.logger.warn(p + " path not exist.", e);
            }
            return new DefaultPage(offset, pageSize, serviceInstances, totalSize);
        });
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        listener.getServiceNames().forEach(serviceName -> this.registerServiceWatcher((String)serviceName, listener));
    }

    @Override
    public void removeServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws IllegalArgumentException {
        listener.getServiceNames().forEach(serviceName -> {
            ZookeeperServiceDiscoveryChangeWatcher watcher = this.watcherCaches.remove(serviceName);
            watcher.stopWatching();
        });
    }

    private void doInServiceRegistry(ThrowableConsumer<ServiceDiscovery> consumer) {
        ThrowableConsumer.execute(this.serviceDiscovery, s -> consumer.accept((ServiceDiscovery)s));
    }

    private <R> R doInServiceDiscovery(ThrowableFunction<ServiceDiscovery, R> function) {
        return ThrowableFunction.execute(this.serviceDiscovery, function);
    }

    protected void registerServiceWatcher(String serviceName, ServiceInstancesChangedListener listener) {
        String path = this.buildServicePath(serviceName);
        try {
            this.curatorFramework.create().creatingParentsIfNeeded().forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(e);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("registerServiceWatcher create path=" + path + " fail.", e);
        }
        CuratorWatcher prev = this.watcherCaches.get(path);
        CuratorWatcher watcher = this.watcherCaches.computeIfAbsent(path, key -> new ZookeeperServiceDiscoveryChangeWatcher(this, serviceName, listener));
        try {
            List addresses = (List)((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher(watcher)).forPath(path);
            if ((prev == null || watcher != prev) && CollectionUtils.isNotEmpty(addresses)) {
                listener.onEvent(new ServiceInstancesChangedEvent(serviceName, this.getInstances(serviceName)));
            }
        }
        catch (KeeperException.NoNodeException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private String buildServicePath(String serviceName) {
        return this.rootPath + "/" + serviceName;
    }
}

