/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public class ForkingClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private final ExecutorService executor = Executors.newCachedThreadPool(new NamedInternalThreadFactory("forking-cluster-timer", true));

    public ForkingClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        try {
            List selected;
            this.checkInvokers(invokers, invocation);
            int forks = this.getUrl().getParameter("forks", 2);
            if (forks <= 0 || forks >= invokers.size()) {
                selected = invokers;
            } else {
                selected = new ArrayList(forks);
                while (selected.size() < forks) {
                    Invoker invoker = this.select(loadbalance, invocation, invokers, selected);
                    if (selected.contains(invoker)) continue;
                    selected.add(invoker);
                }
            }
            RpcContext.getContext().setInvokers(selected);
            AtomicInteger count = new AtomicInteger();
            LinkedBlockingQueue ref = new LinkedBlockingQueue();
            for (Invoker<?> result : selected) {
                this.executor.execute(() -> {
                    block2: {
                        try {
                            Result result = invoker.invoke(invocation);
                            ref.offer(result);
                        }
                        catch (Throwable e) {
                            int value = count.incrementAndGet();
                            if (value < selected.size()) break block2;
                            ref.offer(e);
                        }
                    }
                });
            }
            try {
                Object ret = ref.poll(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
                if (ret instanceof Throwable) {
                    Throwable throwable = (Throwable)ret;
                    throw new RpcException(throwable instanceof RpcException ? ((RpcException)throwable).getCode() : 0, "Failed to forking invoke provider " + selected + ", but no luck to perform the invocation. Last error is: " + throwable.getMessage(), throwable.getCause() != null ? throwable.getCause() : throwable);
                }
                Result result = (Result)ret;
                return result;
            }
            catch (InterruptedException e) {
                throw new RpcException("Failed to forking invoke provider " + selected + ", but no luck to perform the invocation. Last error is: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            RpcContext.getContext().clearAttachments();
        }
    }
}

