/*
 * Decompiled with CFR 0.152.
 */
package weaver.agent.net.sf.ezmorph.object;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import weaver.agent.net.sf.ezmorph.MorphException;
import weaver.agent.net.sf.ezmorph.object.AbstractObjectMorpher;
import weaver.agent.org.apache.commons.lang.builder.EqualsBuilder;
import weaver.agent.org.apache.commons.lang.builder.HashCodeBuilder;

public final class DateMorpher
extends AbstractObjectMorpher {
    private Date defaultValue;
    private String[] formats;
    private boolean lenient;
    private Locale locale;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DateMorpher(String[] formats) {
        this(formats, Locale.getDefault(), false);
    }

    public DateMorpher(String[] formats, boolean lenient) {
        this(formats, Locale.getDefault(), lenient);
    }

    public DateMorpher(String[] formats, Date defaultValue) {
        this(formats, defaultValue, Locale.getDefault(), false);
    }

    public DateMorpher(String[] formats, Date defaultValue, Locale locale, boolean lenient) {
        super(true);
        if (formats == null || formats.length == 0) {
            throw new MorphException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.lenient = lenient;
        this.setDefaultValue(defaultValue);
    }

    public DateMorpher(String[] formats, Locale locale) {
        this(formats, locale, false);
    }

    public DateMorpher(String[] formats, Locale locale, boolean lenient) {
        if (formats == null || formats.length == 0) {
            throw new MorphException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.lenient = lenient;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateMorpher)) {
            return false;
        }
        DateMorpher other = (DateMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.formats, other.formats);
        builder.append(this.locale, other.locale);
        builder.append(this.lenient, other.lenient);
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append(this.getDefaultValue(), other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public Date getDefaultValue() {
        return (Date)this.defaultValue.clone();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.formats);
        builder.append(this.locale);
        builder.append(this.lenient);
        if (this.isUseDefault()) {
            builder.append(this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return (Date)value;
        }
        if (!this.supports(value.getClass())) {
            throw new MorphException(value.getClass() + " is not supported");
        }
        String strValue = (String)value;
        SimpleDateFormat dateParser = null;
        int i = 0;
        while (i < this.formats.length) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(this.formats[i], this.locale);
            } else {
                dateParser.applyPattern(this.formats[i]);
            }
            dateParser.setLenient(this.lenient);
            try {
                return dateParser.parse(strValue.toLowerCase());
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Unable to parse the date " + value);
    }

    public Class morphsTo() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void setDefaultValue(Date defaultValue) {
        this.defaultValue = (Date)defaultValue.clone();
    }

    public boolean supports(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz2.isAssignableFrom(clazz);
    }
}

