/*
 * Decompiled with CFR 0.152.
 */
package weaver.agent.net.sf.json.util;

import java.util.Iterator;
import weaver.agent.net.sf.json.JSON;
import weaver.agent.net.sf.json.JSONArray;
import weaver.agent.net.sf.json.JSONNull;
import weaver.agent.net.sf.json.JSONObject;
import weaver.agent.net.sf.json.util.JSONUtils;
import weaver.agent.net.sf.json.util.WebHijackPreventionStrategy;

public class WebUtils {
    private static final WebHijackPreventionStrategy DEFAULT_WEB_HIJACK_PREVENTION_STRATEGY;
    private static WebHijackPreventionStrategy webHijackPreventionStrategy;

    public static WebHijackPreventionStrategy getWebHijackPreventionStrategy() {
        return webHijackPreventionStrategy;
    }

    public static String protect(JSON json) {
        return WebUtils.protect(json, false);
    }

    public static String protect(JSON json, boolean shrink) {
        String output = !shrink ? json.toString(0) : WebUtils.toString(json);
        return webHijackPreventionStrategy.protect(output);
    }

    public static void setWebHijackPreventionStrategy(WebHijackPreventionStrategy strategy) {
        webHijackPreventionStrategy = strategy == null ? DEFAULT_WEB_HIJACK_PREVENTION_STRATEGY : strategy;
    }

    public static String toString(JSON json) {
        if (json instanceof JSONObject) {
            return WebUtils.toString((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return WebUtils.toString((JSONArray)json);
        }
        return WebUtils.toString((JSONNull)json);
    }

    private static String join(JSONArray jsonArray) {
        int len = jsonArray.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Object value = jsonArray.get(i);
            sb.append(WebUtils.toString(value));
        }
        return sb.toString();
    }

    private static String quote(String str) {
        if (str.indexOf(" ") > -1 || str.indexOf(":") > -1) {
            return JSONUtils.quote(str);
        }
        return str;
    }

    private static String toString(JSONArray jsonArray) {
        try {
            return '[' + WebUtils.join(jsonArray) + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String toString(JSONNull jsonNull) {
        return jsonNull.toString();
    }

    private static String toString(JSONObject jsonObject) {
        if (jsonObject.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        Iterator keys = jsonObject.keys();
        StringBuffer sb = new StringBuffer("{");
        while (keys.hasNext()) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            Object o = keys.next();
            sb.append(WebUtils.quote(o.toString()));
            sb.append(':');
            sb.append(WebUtils.toString(jsonObject.get(String.valueOf(o))));
        }
        sb.append('}');
        return sb.toString();
    }

    private static String toString(Object object) {
        if (object instanceof JSON) {
            return WebUtils.toString((JSON)object);
        }
        return JSONUtils.valueToString(object);
    }

    private WebUtils() {
    }

    static {
        webHijackPreventionStrategy = DEFAULT_WEB_HIJACK_PREVENTION_STRATEGY = WebHijackPreventionStrategy.INFINITE_LOOP;
    }
}

