/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weaver.agent.javassist.CtClass;
import weaver.security.protect.agent.BaseAgent;
import weaver.security.protect.entity.ClassEntity;
import weaver.security.protect.entity.MethodEntity;
import weaver.security.protect.utils.ClassUtils;
import weaver.security.protect.utils.ConfigUtil;
import weaver.security.protect.utils.FileUtil;
import weaver.security.protect.wrapper.ResponseWrapper;

public class RunAgentMain1 {
    private static Map<String, Class> agentTemplateMap = new HashMap<String, Class>();
    private static Map<String, Class> originalClassToFileCacheMap = new HashMap<String, Class>();

    public void entrance(String args, Instrumentation instrumentation) throws Exception {
        Class[] loadedClasses;
        List<BaseAgent> baseAgents = this.agentTemplateList();
        for (Class loadedClass : loadedClasses = instrumentation.getAllLoadedClasses()) {
            String name = loadedClass.getName();
            for (BaseAgent driverAgent : baseAgents) {
                if (!driverAgent.isSupport(name)) continue;
                ResponseWrapper responseWrapper = driverAgent.enhanceClass(loadedClass);
                CtClass ctClass = responseWrapper.getCtClass();
                instrumentation.redefineClasses(new ClassDefinition(loadedClass, ctClass.toBytecode()));
                ctClass.detach();
                FileUtil.writeClassFile("D:\\", ctClass);
                this.printEnhanceLog(responseWrapper.getClassEntity());
            }
        }
    }

    private List<BaseAgent> agentTemplateList() throws Exception {
        ArrayList<BaseAgent> baseAgents = new ArrayList<BaseAgent>();
        List<ClassEntity> classEntities = ConfigUtil.classEntityTargetList();
        for (ClassEntity classEntity : classEntities) {
            baseAgents.add(this.generateBaseAgent(classEntity));
        }
        return baseAgents;
    }

    private BaseAgent generateBaseAgent(ClassEntity classEntity) {
        String checkFlag = classEntity.getCheckRule();
        if (checkFlag == null || "".equals(checkFlag)) {
            throw new RuntimeException("\u63d2\u6869\u6807\u8bc6\u4e3a\u7a7a");
        }
        Class aClass = agentTemplateMap.get(checkFlag);
        if (aClass == null) {
            throw new RuntimeException("\u83b7\u53d6\u6a21\u677f\u5bf9\u8c61\u4e3a\u7a7a\uff1acheckRule = " + checkFlag + ",classEntity = " + classEntity + ",agentTemplateMap" + agentTemplateMap);
        }
        try {
            Constructor constructor = aClass.getConstructor(ClassEntity.class);
            return (BaseAgent)constructor.newInstance(classEntity);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f8b\u5316\u63d2\u6869\u5bf9\u8c61\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void printEnhanceLog(ClassEntity classEntity) {
        if (classEntity == null) {
            return;
        }
        String targetClassName = classEntity.getTargetClassName();
        List<MethodEntity> methods = classEntity.getMethods();
        for (MethodEntity method : methods) {
            System.out.println("\u589e\u5f3a\u6210\u529f\uff1aclass=" + targetClassName + "#" + method.getMethodNmae() + "(" + method.getParams() + ")");
        }
    }

    static {
        try {
            System.out.println("----\u6a21\u677f\u5b9e\u4f8b\u5f00\u59cb----");
            agentTemplateMap = ClassUtils.agentTemplateMap(BaseAgent.class);
            for (Map.Entry<String, Class> stringClassEntry : agentTemplateMap.entrySet()) {
                System.out.println("key=" + stringClassEntry.getKey() + ", template=" + stringClassEntry.getValue().getName());
            }
            System.out.println("----\u6a21\u677f\u5b9e\u4f8b\u7ed3\u675f----");
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u6267\u884c\u63d2\u6869\u89c4\u5219\u7684\u6a21\u677f\u5b9e\u4f8b\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

