/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect.agent.template.file;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weaver.agent.javassist.CannotCompileException;
import weaver.agent.javassist.CtBehavior;
import weaver.agent.javassist.CtClass;
import weaver.agent.javassist.CtConstructor;
import weaver.security.protect.agent.ABaseAgent;
import weaver.security.protect.entity.MethodEntity;
import weaver.security.protect.wrapper.ResponseWrapper;

public class FileAgentTemplate
extends ABaseAgent {
    private Map<String, String> fileConstructorCode = new HashMap<String, String>();

    public FileAgentTemplate() {
        this.fileConstructorCode.put("java.io.File(java.lang.String)", this.fileOutputStream_javaLangString_code());
        this.fileConstructorCode.put("java.io.File(java.lang.String,java.lang.String)", this.fileOutputStream_javaLangString_boolean_code());
        this.fileConstructorCode.put("java.io.File(java.io.File,java.lang.String)", this.fileOutputStream_javaIoFile_code());
    }

    @Override
    public ResponseWrapper doEnhanceClass(CtClass ctClass) throws Exception {
        List<MethodEntity> methods = super.getClassEntity().getMethods();
        try {
            for (MethodEntity method : methods) {
                CtConstructor[] constructors;
                String params = method.getParams();
                String newParams = "(" + params + ")";
                for (CtConstructor constructor : constructors = ctClass.getConstructors()) {
                    String longName = constructor.getLongName();
                    if (!longName.contains(newParams)) continue;
                    String code = this.fileConstructorCode.get(constructor.getLongName());
                    this.insertCodeBeforeAgain(constructor, code);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ResponseWrapper(ctClass, super.getClassEntity());
    }

    public void insertCodeBefore(CtBehavior ctConstructor, String paramIndex) throws CannotCompileException {
        String insertBeforeStr = "";
        insertBeforeStr = "String path_ = $1.getPath();\n" + this.commonCode();
        if (ctConstructor != null) {
            ctConstructor.insertBefore(insertBeforeStr);
        }
    }

    public void insertCodeBeforeAgain(CtBehavior ctConstructor, String code) throws CannotCompileException {
        if (ctConstructor != null) {
            ctConstructor.insertBefore(code);
        }
    }

    @Override
    public String getCheckRule() {
        return "oriFileCheck";
    }

    public String fileOutputStream_javaLangString_code() {
        String code = "String path_ = $1;\n";
        code = code + this.commonCode();
        return code;
    }

    public String fileOutputStream_javaLangString_boolean_code() {
        String code = "String path_ = $1;\n";
        String code1 = "String path1_ = $2;\n";
        code = code + code1 + this.commonCodeAndParam2();
        return code;
    }

    public String fileOutputStream_javaIoFile_code() {
        String code = "String path_ = $1.getPath();\n";
        String code1 = "String path1_ = $2;\n";
        code = code + code1 + this.commonCodeAndParam2();
        return code;
    }

    private String commonCode() {
        String strCode = "if (path_ == null) {\n            path_ = \"\";\n        }\n\n        // \u83b7\u53d6\u8bf7\u6c42uri\n        String value_ = \"\";\n        try {\n            java.lang.Class aClass_ = Class.forName(\"weaver.security.protect.bridge.bridge.RequestPathBridge\");\n            value_ = aClass_.getMethod(\"getValue\",null).invoke(null,null).toString();\n        } catch (java.lang.Exception exception) {\n            System.out.println(\"\u589e\u5f3aFile\u6e90\u7801\u5f02\u5e38\uff1a\" + exception.toString());\n            value_ = \"\";\n        }\n\n        if (!value_.equals(\"\")) {\n            value_ = value_.toLowerCase();\n            path_ = path_.replaceAll(\"/+\",\"/\");\n            path_ = path_.replaceAll(\"\\\\\\\\+\",\"/\").toLowerCase();\n\n            if (path_.contains(\"..\")) {\n                boolean flag = false;\n                String skipFilePathCheck = System.getProperty(\"skipFilePathCheck\");\n                if (skipFilePathCheck != null) {\n                    String[] skipWriteUrlCheckSplit = skipFilePathCheck.split(\",\");\n                    for (int m = 0; m < skipWriteUrlCheckSplit.length; m++) {\n                        String writeUrl = skipWriteUrlCheckSplit[m];\n                        if (value_.startsWith(writeUrl)) {\n                            flag = true;\n                        }\n                    }\n                }\n                if (!flag) {\n                    throw new RuntimeException(\"[security reject]file\u53c3\u6578\u4e0d\u5408\u898f\uff0curi=\" + value_ + \" path=\" + path_);\n                }\n\n            }\n        }";
        return strCode;
    }

    private String commonCodeAndParam2() {
        String strCode = "if (path1_ == null) {\n            path1_ = \"\";\n}\nif (path_ == null) {\n            path_ = \"\";\n}\n\n        // \u83b7\u53d6\u8bf7\u6c42uri\n        String value_ = \"\";\n        try {\n            java.lang.Class aClass_ = Class.forName(\"weaver.security.protect.bridge.bridge.RequestPathBridge\");\n            value_ = aClass_.getMethod(\"getValue\",null).invoke(null,null).toString();\n        } catch (java.lang.Exception exception) {\n            System.out.println(\"\u589e\u5f3aFile\u6e90\u7801\u5f02\u5e38\uff1a\" + exception.toString());\n            value_ = \"\";\n        }\n\n if (!value_.equals(\"\")) {\n            value_ = value_.toLowerCase();\n            path_ = path_.replaceAll(\"/+\",\"/\");\n            path_ = path_.replaceAll(\"\\\\\\\\+\",\"/\").toLowerCase();\n\n            if (path_.contains(\"..\") || (path1_ != null && !\"\".equals(path1_) && path1_.contains(\"..\"))) {\n                boolean flag = false;\n                String skipFilePathCheck = System.getProperty(\"skipFilePathCheck\");\n                if (skipFilePathCheck != null) {\n                    String[] skipWriteUrlCheckSplit = skipFilePathCheck.split(\",\");\n                    for (int m = 0; m < skipWriteUrlCheckSplit.length; m++) {\n                        String writeUrl = skipWriteUrlCheckSplit[m];\n                        if (value_.startsWith(writeUrl)) {\n                            flag = true;\n                        }\n                    }\n                }\n                if (!flag) {\n                    throw new RuntimeException(\"[security reject]file\u53c3\u6578\u4e0d\u5408\u898f\uff0curi=\" + value_ + \" path=\" + path_ + \" path1_=\" + path1_);\n                }\n\n            }\n        }";
        return strCode;
    }

    public void aa() throws Exception {
        String path_ = "";
        if (path_ == null) {
            path_ = "";
        }
        String value_ = "";
        try {
            Class<?> aClass_ = Class.forName("weaver.security.protect.bridge.bridge.RequestPathBridge");
            value_ = aClass_.getMethod("getValue", null).invoke(null, null).toString();
        }
        catch (Exception exception) {
            System.out.println("\u589e\u5f3aFile\u6e90\u7801\u5f02\u5e38\uff1a" + exception.toString());
            value_ = "";
        }
        if (!value_.equals("")) {
            value_ = value_.toLowerCase();
            path_ = path_.replaceAll("/+", "/");
            if ((path_ = path_.replaceAll("\\\\+", "/").toLowerCase()).contains("..")) {
                boolean flag = false;
                String skipFilePathCheck = System.getProperty("skipFilePathCheck");
                if (skipFilePathCheck != null) {
                    String[] skipWriteUrlCheckSplit = skipFilePathCheck.split(",");
                    for (int m = 0; m < skipWriteUrlCheckSplit.length; ++m) {
                        String writeUrl = skipWriteUrlCheckSplit[m];
                        if (!value_.startsWith(writeUrl)) continue;
                        flag = true;
                    }
                }
                if (!flag) {
                    throw new RuntimeException("[security reject]file\u53c3\u6578\u4e0d\u5408\u898f\uff0curi=" + value_ + " path=" + path_);
                }
            }
        }
    }

    public void aa1() throws Exception {
        String path_ = "";
        String path1_ = "";
        if (path_ == null) {
            path_ = "";
        }
        String value_ = "";
        try {
            Class<?> aClass_ = Class.forName("weaver.security.protect.bridge.bridge.RequestPathBridge");
            value_ = aClass_.getMethod("getValue", null).invoke(null, null).toString();
        }
        catch (Exception exception) {
            System.out.println("\u589e\u5f3aFile\u6e90\u7801\u5f02\u5e38\uff1a" + exception.toString());
            value_ = "";
        }
        if (!value_.equals("")) {
            value_ = value_.toLowerCase();
            path_ = path_.replaceAll("/+", "/");
            if ((path_ = path_.replaceAll("\\\\+", "/").toLowerCase()).contains("..") || path1_ != null && !"".equals(path1_) && path1_.contains("..")) {
                boolean flag = false;
                String skipFilePathCheck = System.getProperty("skipFilePathCheck");
                if (skipFilePathCheck != null) {
                    String[] skipWriteUrlCheckSplit = skipFilePathCheck.split(",");
                    for (int m = 0; m < skipWriteUrlCheckSplit.length; ++m) {
                        String writeUrl = skipWriteUrlCheckSplit[m];
                        if (!value_.startsWith(writeUrl)) continue;
                        flag = true;
                    }
                }
                if (!flag) {
                    throw new RuntimeException("[security reject]file\u53c3\u6578\u4e0d\u5408\u898f\uff0curi=" + value_ + " path=" + path_ + " path1_=" + path1_);
                }
            }
        }
    }
}

