/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect.agent.template.sql;

import java.util.List;
import weaver.agent.javassist.CannotCompileException;
import weaver.agent.javassist.CtBehavior;
import weaver.agent.javassist.CtClass;
import weaver.security.protect.agent.ABaseAgent;
import weaver.security.protect.entity.MethodEntity;
import weaver.security.protect.utils.JavassistUtil;
import weaver.security.protect.utils.LogWriter;
import weaver.security.protect.wrapper.ResponseWrapper;

public class CommonTemplate
extends ABaseAgent {
    @Override
    public ResponseWrapper doEnhanceClass(CtClass ctClass) throws Exception {
        List<MethodEntity> methods = super.getClassEntity().getMethods();
        for (MethodEntity method : methods) {
            try {
                CtBehavior ctConstructor = JavassistUtil.getCtMethodAndCtConstructor(this.getClassEntity().getTargetClassName(), method, ctClass);
                if (method.getCheckClass().contains("After")) {
                    this.insertCodeAfter(ctConstructor, method);
                    continue;
                }
                this.insertCodeBefore(ctConstructor, method);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogWriter.writeError("commonTemplate enhance class exception. MethodName = " + method.getMethodNmae() + " ClassName = " + ctClass.getName(), e);
            }
        }
        return new ResponseWrapper(ctClass, super.getClassEntity());
    }

    public void insertCodeAfter(CtBehavior ctBehavior, MethodEntity method) throws CannotCompileException {
        String paramIndex = method.getParamIndex();
        String code = this.newBashCode(paramIndex, method.getCheckClass());
        if (ctBehavior != null) {
            ctBehavior.insertAfter(code);
        }
    }

    public String newBashCode(String paramIndex, String checkClassName) {
        return "weaver.security.classLoader.ClassLoaderManager clm = weaver.security.classLoader.ClassLoaderManager.getInstance();Class aClass = clm.loadClass(\"weaver.security.agentRules.utils.CheckRuleInstance\");java.lang.reflect.Method check = aClass.getMethod(\"check\",new Class[] {Object.class,Object.class,String.class});Object o = check.invoke(null,new Object[]{" + paramIndex + ",new String(\"" + checkClassName + "\")});";
    }

    public void insertCodeBefore(CtBehavior ctBehavior, MethodEntity method) throws CannotCompileException {
        String[] paramIndexSplit;
        String paramIndex = method.getParamIndex();
        for (String index : paramIndexSplit = paramIndex.split(",")) {
            String paramType;
            String newParamIndex = this.checkParamIndex(index);
            String code = this.bashCode(this.checkParamIndex(index), method.getCheckClass());
            String params = method.getParams();
            if (params != null && params.length() > 0 && (paramType = params.split(",")[Integer.valueOf(index) - 1]).equals("java.lang.String")) {
                code = code + newParamIndex + "= (String)o;";
            }
            if (ctBehavior == null) continue;
            ctBehavior.insertBefore(code);
        }
    }

    public String bashCode(String paramIndex, String checkClassName) {
        return "weaver.security.classLoader.ClassLoaderManager clm = weaver.security.classLoader.ClassLoaderManager.getInstance();Class aClass = clm.loadClass(\"weaver.security.agentRules.utils.CheckRuleInstance\");java.lang.reflect.Method check = aClass.getMethod(\"check\",new Class[] {Object.class,String.class});Object o = check.invoke(null,new Object[]{" + paramIndex + ", new String(\"" + checkClassName + "\")});";
    }

    public String checkParamIndex(String paramIndex) {
        if (paramIndex.matches("^\\d{0,9}")) {
            return "$" + paramIndex;
        }
        return "$1";
    }

    @Override
    public String getCheckRule() {
        return "common";
    }
}

