/*
 * Decompiled with CFR 0.152.
 */
package weaver.security.protect.utils;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weaver.agent.javassist.ClassPool;
import weaver.agent.javassist.CtBehavior;
import weaver.agent.javassist.CtClass;
import weaver.agent.javassist.CtConstructor;
import weaver.agent.javassist.CtMethod;
import weaver.agent.javassist.LoaderClassPath;
import weaver.agent.javassist.NotFoundException;
import weaver.security.protect.RunAgentMain;
import weaver.security.protect.entity.MethodEntity;
import weaver.security.protect.utils.FileUtil;

public class JavassistUtil {
    public static final ClassPool classPool = ClassPool.getDefault();
    public static CtClass booleanType = CtClass.booleanType;
    public static CtClass doubleType = CtClass.doubleType;
    public static CtClass longType = CtClass.longType;
    public static CtClass floatType = CtClass.floatType;
    public static CtClass intType = CtClass.intType;
    public static CtClass byteType = CtClass.byteType;
    public static CtClass charType = CtClass.charType;
    public static CtClass shortType = CtClass.shortType;
    public static Map<String, CtClass> paramType = new HashMap<String, CtClass>();

    public static CtClass getCtClassByTargetName(String targetName) throws NotFoundException {
        return classPool.get(targetName);
    }

    public static CtBehavior getCtMethodAndCtConstructor(String className, MethodEntity methodEntity, CtClass ctClass) throws NotFoundException {
        String methodNmae;
        if ((className = className.substring(className.lastIndexOf(".") + 1, className.length())).equals(methodNmae = methodEntity.getMethodNmae())) {
            return JavassistUtil.getCtConstructor(methodEntity, ctClass);
        }
        return JavassistUtil.getCtMethod(methodEntity, ctClass);
    }

    public static CtMethod getCtMethod(MethodEntity methodEntity, CtClass ctClass) throws NotFoundException {
        if (methodEntity.getParams() == null || methodEntity.getParams().isEmpty()) {
            return ctClass.getDeclaredMethod(methodEntity.getMethodNmae());
        }
        CtClass[] params = JavassistUtil.getParams(methodEntity);
        return ctClass.getDeclaredMethod(methodEntity.getMethodNmae(), params);
    }

    public static CtConstructor getCtConstructor(MethodEntity methodEntity, CtClass ctClass) throws NotFoundException {
        if (methodEntity.getParams() == null || methodEntity.getParams().isEmpty()) {
            return ctClass.getDeclaredConstructor(null);
        }
        CtClass[] params = JavassistUtil.getParams(methodEntity);
        return ctClass.getDeclaredConstructor(params);
    }

    public static CtClass[] getParams(MethodEntity methodEntity) throws NotFoundException {
        List<String> parameters = Arrays.asList(methodEntity.getParams().split(","));
        CtClass[] classes = new CtClass[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            classes[i] = JavassistUtil.changCtClass(parameters.get(i));
        }
        return classes;
    }

    public static CtClass changCtClass(String param) throws NotFoundException {
        if (!param.contains(".")) {
            return paramType.get(param);
        }
        return JavassistUtil.getType(param);
    }

    public static CtClass getType(String type) {
        try {
            return classPool.get(type);
        }
        catch (NotFoundException e) {
            try {
                return classPool.getCtClass(type);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static byte[] readOldClassFileToByte(String path, Class loadedClass) throws Exception {
        String clsAsResource = path + File.separator + loadedClass.getName().replace('.', '/').concat(".class");
        System.out.println("\u8bfb\u53d6\u7684\u8def\u5f84\uff1a" + clsAsResource);
        return FileUtil.readToByte(clsAsResource);
    }

    public static byte[] writeOldClassFileToByte(Class loadedClass) throws Exception {
        classPool.appendClassPath(new LoaderClassPath(loadedClass.getClassLoader()));
        CtClass ctClass = classPool.get(loadedClass.getName());
        return ctClass.toBytecode();
    }

    public static void writeOldClassFileToFile(Class loadedClass, String pathPrefix) throws Exception {
        classPool.appendClassPath(new LoaderClassPath(loadedClass.getClassLoader()));
        CtClass ctClass = classPool.get(loadedClass.getName());
        ctClass.writeFile(pathPrefix);
    }

    public static Class getClassInstanceToInstrumentation(String className) {
        Class[] allLoadedClasses;
        if (className == null || "".equals(className)) {
            return null;
        }
        for (Class clazz : allLoadedClasses = RunAgentMain.weaverInstrumentation.getAllLoadedClasses()) {
            String name = clazz.getName();
            if (!className.equals(name)) continue;
            return clazz;
        }
        return null;
    }

    static {
        paramType.put("boolean", booleanType);
        paramType.put("double", doubleType);
        paramType.put("long", longType);
        paramType.put("float", floatType);
        paramType.put("int", intType);
        paramType.put("byte", byteType);
        paramType.put("char", charType);
        paramType.put("short", shortType);
    }
}

