<%@ page import="com.alibaba.fastjson.JSONObject,weaver.general.BaseBean,weaver.general.Util" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" %>
<%@ page import="weaver.security.classLoader.ClassLoaderManager" %>
<%@ page import="java.util.*" %>
<%@ page import="java.security.ProtectionDomain" %>
<%@ page import="java.security.CodeSource" %>
<%@ page import="java.net.URL" %>
<%@ page import="java.io.IOException" %>
<%@ page import="weaver.hrm.User" %>
<%@ page import="weaver.hrm.HrmUserVarify" %>
<jsp:useBean id="xssUtil" class="weaver.filter.XssUtil" scope="page"></jsp:useBean>

<%

    User user = HrmUserVarify.getUser(request, response);
    if (user == null) {
        response.sendRedirect("/login/Login.jsp");
        return;
    }
    if (user.getUID() != 1) {
        response.sendRedirect("/notice/noright.jsp");
        return;
    }

    out.println("<h2>内存马检测</h2>");
    Map<String,Map<String,Class>> result = check();
    if (result == null || result.size() == 0) {
        out.println("检测出现异常,获取检测结果为空");
        return;
    }

    Map<String, Class> normal = result.get("normal");
    Map<String, Class> notNormal = result.get("notNormal");

    Map<String, Class> notNormalJsp = new HashMap<String, Class>();
    Map<String, Class> notNormalClass = new HashMap<String, Class>();

    out.println("<span style=\"font-weight: bold\">一共检测" + (normal.size() + notNormal.size()) + "个, 其中发现可疑文件个数" + notNormal.size() + "个" + "。</span>");

    if (notNormal.size() == 0) return;

    Set<Map.Entry<String, Class>> entries = notNormal.entrySet();
    for (Map.Entry<String, Class> entry : entries) {
        String className = entry.getKey();
        Class clazz = entry.getValue();
        if (className.startsWith("_jsp")) {
            notNormalJsp.put(className, clazz);
        } else {
            notNormalClass.put(className, clazz);
        }
    }
    out.println("<h3>可疑文件详情：</h3>");
    /*out.println("<h3>1.JSP文件：</h3>");
    if (notNormalJsp.size() == 0) {
        out.println("无<br>");
    } else {
        out.println("<p style='font-weight: bold;'>详情：</p>");
        readMapInfo(notNormalJsp, out);

        out.println("<p style='font-weight: bold;'>原因：</p>");
        out.println("<span>原文件删除，但缓存文件仍然存在。</span><br>");

        out.println("<p style='font-weight: bold;'>处理方式：</p>");
        out.println("<span>删除以下路径文件</span><br>");
        Set<String> keySet = notNormalJsp.keySet();
        for (String classNameKey : keySet) {
            out.println("删除ecology/WEB-INF/work/" + classNameKey.replace("_jsp","").replace("_","").replace(".","/").concat(".jsp") + "<br>");
        }
        out.println("<span>如果需要删除的文件未在指定路径找到，应用重启即可。</span><br>");
    }*/

    //out.println("<h3>2.其他文件：</h3>");
    if (notNormalClass.size() == 0) {
        out.println("无<br>");
    } else {
        out.println("<p style='font-weight: bold;'>详情：</p>");
        readMapInfo(notNormalClass, out);
    }


%>

<%!

    public void readMapInfo(Map<String, Class> classMap, JspWriter out) throws IOException {
        Set<Map.Entry<String, Class>> entries = classMap.entrySet();
        String realPath = "";
        for (Map.Entry<String, Class> entry : entries) {
            String className = entry.getKey();
            Class clazz = entry.getValue();
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain != null) {
                CodeSource codeSource = protectionDomain.getCodeSource();
                if (codeSource != null) {
                    URL location = codeSource.getLocation();
                    try {
                        realPath = java.net.URLDecoder.decode(location.getPath(), "utf-8");
                    } catch (Throwable e) {
                        realPath = "";
                    }
                }
            }
            if (realPath.contains("/weaversso/")) continue;
            out.println("className = " + className + "<br>");
            out.println("classLoader = " + clazz.getClassLoader() +"<br>");
            out.println("realPath = " + realPath + "<br>");
            out.println("protectionDomain = " + protectionDomain + "<br>");
            out.println("------------------------------------------------<br>");
        }
    }

    public Map<String,Map<String,Class>> check() {
        try {
            ClassLoaderManager clm = ClassLoaderManager.getInstance();
            Class aClass = clm.loadClass("weaver.security.agentRules.utils.AgentCheckUtil");
            return(Map<String,Map<String,Class>>) aClass.getMethod("checkMemoryHorse").invoke(null);
        } catch (Exception e) {
            System.out.println("出现异常");
            e.printStackTrace();
        }
        return null;
    }

%>
