<%@ page language="java" contentType="text/html; charset=UTF-8" %><%@ page import="net.sf.json.JSONObject" %>
<%@ page import="java.lang.reflect.Field" %>
<%@ page import="java.io.File" %>
<%@ page import="org.apache.commons.io.FileUtils" %>
<%@ page import="weaver.security.classLoader.ClassLoaderManager" %>
<%@ page import="java.util.concurrent.ScheduledExecutorService" %>
<%@ page import="weaver.hrm.HrmUserVarify" %>
<%@ page import="weaver.hrm.User" %>
<%@ page import="java.util.UUID" %>
<%@ page import="weaver.filter.XssUtil" %>
<jsp:useBean id="csui" class="weaver.filter.msg.CheckSecurityUpdateInfo"></jsp:useBean>
<jsp:useBean id="xssUtil" class="weaver.filter.XssUtil" scope="page"></jsp:useBean>
<%!

	public void clearAgentThreadPool() {
		try {
			agentThreadPool();
			accessThreadPool();
		} catch (Exception e) {
			System.out.println(">>agent：updateclassJsp --> clear agentThreadPool exception = " + e.getMessage());
			e.printStackTrace();
		}
	}

	public void accessThreadPool() {
		XssUtil xssUtil = new XssUtil();
		try {
			ClassLoaderManager clm = ClassLoaderManager.getInstance();
			Class aClass = clm.loadClass("weaver.security.detail.SecurityAccessTask");
			if (aClass == null) {
				xssUtil.writeLog(">>>access >> clear access thread pool object is null", true);
			}
			aClass.getMethod("shutDownAccessThread").invoke(null);
		} catch (Exception e) {
			xssUtil.writeError(e);
			e.printStackTrace();
		}
	}

	public void agentThreadPool() {
		try {
			ClassLoaderManager clm = ClassLoaderManager.getInstance();
			Class aClass = clm.loadClass("weaver.security.agentRules.task.AgentTask");
			Field declaredFields = aClass.getDeclaredField("scheduledExecutorService");
			declaredFields.setAccessible(true);
			ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService) declaredFields.get(ScheduledExecutorService.class);
			scheduledExecutorService.shutdown();
			System.out.println(">>agent：updateclassJsp --> clear agentThreadPool ScheduledExecutorService = " + scheduledExecutorService);
		} catch (Exception e) {
			System.out.println(">>agent：updateclassJsp --> clear agentThreadPool exception = " + e.getMessage());
			e.printStackTrace();
		}
	}


	private void loadAgentClass(String method) {
		try {
			ClassLoaderManager clm = ClassLoaderManager.getInstance();
			Class aClass = clm.loadClass("weaver.security.agentRules.utils.AgentCheckUtil");
			Object invoke = aClass.getMethod(method).invoke(null);
		} catch (Exception e) {
			new XssUtil().writeLog(">>agent：updateClass reload attach exception = " + e.getMessage(), true);
			e.printStackTrace();
		}
	}

%>
<%
	JSONObject result = new JSONObject();
	boolean isValid = false;
	User user = HrmUserVarify.getUser (request , response) ;
	int UID = xssUtil.getIntValue(""+xssUtil.getRule().get("userID"),1);
	if (user!=null && user.getUID()==UID)
	{
		isValid = true;
	}
	if(!isValid){
		File tokenFile = new File(xssUtil.getRootPath() + File.separatorChar + "WEB-INF" + File.separatorChar+"securityRule"+File.separatorChar+"weaver_security_cache_token");
		if(!tokenFile.exists()){
			result.put("result", false);
			result.put("msg", "token文件不存在，认证失败。");
			out.println(result.toString());
			return;
		}
		String rnd = request.getParameter("rnd");
		String token = FileUtils.readFileToString(tokenFile);
		if(token == null || "".equals(token.trim()) || !token.trim().equals(rnd)){
			result.put("result", false);
			result.put("msg", "token信息错误，认证失败。");
			out.println(result.toString());
			return;
		}
		isValid = true;
	}
	if(isValid){
			String src = request.getParameter("src");
			if("class".equals(src)){
				//更新class规则的刷新
				clearAgentThreadPool();
				ClassLoaderManager.newClassLoader(xssUtil.getRootPath());
				new weaver.filter.msg.CheckSecurityUpdateInfo();
				xssUtil = new XssUtil();
				xssUtil.initRules(true);
				loadAgentClass("enhanceClassAndHot");
				xssUtil.writeLog("刷新"+src+"缓存数据完成", true);
				result.put("result", true);
				result.put("msg", "缓存刷新成功。");
				result.put("refreshTime", XssUtil.getCurrentTimeString());
			}else if("xml".equals(src)){
				//更新xml规则的刷新
				xssUtil.initRules(true);
				xssUtil.writeLog("刷新"+src+"缓存数据完成", true);
				result.put("result", true);
				result.put("msg", "缓存刷新成功。");
				result.put("refreshTime", XssUtil.getCurrentTimeString());
			}else if("status".equals(src)){
				//获取安全补丁包状态信息
				xssUtil.writeLog("获取安全补丁包状态信息", true);
				result.put("result", true);
				result.put("version",csui.getVersion());
				result.put("firewallStatus", xssUtil.enableFirewall());
				result.put("firewallStatusLabel", xssUtil.enableFirewall()?"已生效":"未生效");
			}
			
	}else{
			result.put("result", false);
			result.put("msg", "缓存刷新失败，无权限。");
	}
		out.println(result.toString());
%>