
<%@ page import="weaver.security.classLoader.ClassLoaderManager" %>
<%@ page import="java.lang.reflect.Method" %>
<%@ page import="weaver.hrm.User" %>
<%@ page import="weaver.hrm.HrmUserVarify" %>
<%@ page import="weaver.filter.XssUtil" %>
<%@ page import="java.util.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" %>
<jsp:useBean id="xssUtil" class="weaver.filter.XssUtil" scope="page"></jsp:useBean>

<%

    // 主要用于同步本地demo中的代码
    User user = HrmUserVarify.getUser(request, response);
    String secondPrefixPath = xssUtil.null2String(xssUtil.getRule().get("second-prefix-path"));
    int UID = xssUtil.getIntValue("" + xssUtil.getRule().get("userID"), 1);
    if (user == null || user.getUID() != UID) {
        response.sendRedirect(secondPrefixPath + "/notice/noright.jsp");
        return;
    }


%>

<%
    String doubleLoginCheckSuccessTime = (String) session.getAttribute("doubleLoginCheckSuccessTime");
    long currentData = new Date().getTime();
    if (doubleLoginCheckSuccessTime == null || currentData - Long.valueOf(doubleLoginCheckSuccessTime) > 10 * 60 * 1000) {
%>
<jsp:include page="/security/login/commonSecondLogin.jsp" />
<% return; }%>

<%

    // 加白接口
    String url = request.getParameter("url");

    // 切换为警告模式
    String isWarn = request.getParameter("isWarn");
    String warnLevel = request.getParameter("warnLevel");
    int day = xssUtil.getIntValue(xssUtil.null2String(request.getParameter("day")),0);

    // 切换为全部拦截模式
    String isOpen = request.getParameter("isOpen");

    //禁止接口
    String forbiddenUrl = request.getParameter("forbiddenUrl");
    String type = request.getParameter("type");

    boolean flag = false;

    if (url != null && !"".equals(url)) {
        List<String> list = new ArrayList<String>();
        Map<String, Map<String, String>> blockDelayUrlMap = (Map<String, Map<String, String>>) xssUtil.getRule().get("blockDelayUrlMap");
        if (url.contains(",")) {
            String[] split = url.split(",");
            for (String s : split) {
                if (!s.startsWith("/")) continue;
                list.add(s.toLowerCase());
            }
        } else if (url.startsWith("/")) {
            list.add(url.toLowerCase());
        }

        for (String s : list) {
            Map<String, String> data = blockDelayUrlMap.get(s);
            if (data == null) {
                out.print("更新失败，接口地址不合规");
                return;
            }
        }

        flag = urlToWhite(list);
    } else if (isWarn != null && !"".equals(isWarn)) {
        //flag = urlToWarn(isWarn, day, warnLevel);
        flag = urlToWarn(isWarn, day, "2");
    } else if (isOpen != null && isOpen.equals("1")) {
        String data = warnToBlock(isOpen);
        out.println(data);
        return;
    } else if (forbiddenUrl != null && forbiddenUrl.startsWith("/")) {
        String data = forbiddenUrl(forbiddenUrl, type);
        out.println(data);
        return;
    }


    out.println(flag?"更新成功":"更新失败");

%>




<%!

    // 对接口放行
    public boolean urlToWhite(List<String> whiteList) {
        try {
            if (whiteList == null || whiteList.size() == 0) return false;
            ClassLoaderManager clm = ClassLoaderManager.getInstance();
            Class aClass = clm.loadClass("weaver.security.rules.ruleImp.SecurityRuleOldUrlCheck");
            Method method = aClass.getMethod("updateDelayUrlTimeToCache", new Class[]{List.class});
            method.invoke(aClass.newInstance(),whiteList);
        } catch (Exception e) {
            new XssUtil().writeError(e);
            return false;
        }
        return true;
    }

    // 修改拦截为警告模式
    public boolean urlToWarn(String isWarn, int warnDay, String warnLevel) {
        try {
            ClassLoaderManager clm = ClassLoaderManager.getInstance();
            Class aClass = clm.loadClass("weaver.security.rules.ruleImp.SecurityRuleOldUrlCheck");
            Method method = aClass.getMethod("updateDelayUrlTimeToWarn", new Class[]{String.class, int.class, String.class});
            method.invoke(aClass.newInstance(),isWarn, warnDay, warnLevel);
        } catch (Exception e) {
            new XssUtil().writeError(e);
            return false;
        }
        return true;
    }

    // 将警告模式切换成拦截模式
    public String warnToBlock(String isOpen) {
        try {
            ClassLoaderManager clm = ClassLoaderManager.getInstance();
            Class aClass = clm.loadClass("weaver.security.rules.ruleImp.SecurityRuleOldUrlCheck");
            Method method = aClass.getMethod("updateWarnToBlock", new Class[]{String.class});
            Map<String, String> resultMap = (Map<String, String>) method.invoke(aClass.newInstance(), isOpen);
            String code = resultMap.get("code");
            String msg = resultMap.get("msg");
            if (code.equals("200")) {
                return "200";
            } else {
                return msg;
            }
        } catch (Exception e) {
            new XssUtil().writeError(e);
        }
        return "开启失败，联系安全组处理.";
    }

    public String forbiddenUrl(String url, String type) {
        try {
            ClassLoaderManager clm = ClassLoaderManager.getInstance();
            Class aClass = clm.loadClass("weaver.security.rules.ruleImp.SecurityRuleOldUrlCheck");
            Map<String, String> resultMap = null;
            if ("1".equals(type)) {
                Method method = aClass.getMethod("pathToBlock", new Class[]{String.class});
                resultMap = (Map<String, String>) method.invoke(aClass.newInstance(), url);
            } else if ("2".equals(type)) {
                Method method = aClass.getMethod("pathToSkipBlock", new Class[]{String.class});
                resultMap = (Map<String, String>) method.invoke(aClass.newInstance(), url);
            }

            if (resultMap == null) {
                new XssUtil().writeLog("updateTime forbiddenUrl error url = " + url + " type = " + type);
                return "type参数不合规";
            }
            String code = resultMap.get("code");
            String msg = resultMap.get("msg");
            if (code.equals("200")) {
                return "200";
            } else {
                return msg;
            }
        } catch (Exception e) {
            new XssUtil().writeError(e);
        }
        return "禁止失败，联系安全组处理.";
    }

%>